﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

    // DataAbort 割り込みの動作
    // 不正確なデータアボートならカーネルパニック
    //
    // 正確なデータアボートの場合
    // 　svc スタックの残りが一定以下ならカーネルパニック
    //   svc モードへ以降しつつ、例外発生時のコンテキストをスタックに保存
    //   割り込みを有効にして、データアボートハンドラを呼ぶ
EXP_VECTOR_ENTRY(_ZN2nn4kern6ARMv7A16DataAbortHandlerEv)
    // ABT モード -------

    sub     lr, lr, #8          // 復帰先は LR - 8

    // 割り込み発生時の状況を調べる
    mov     sp, r0
    mrs     r0, spsr;
    and     r0, r0, #HW_PSR_CPU_MODE_MASK
    cmp     r0, #HW_PSR_USR_MODE
    mov     r0, sp
    bne     privilege_mode_sequence_data


// ユーザモードだった場合
user_mode_sequence_data:
    // ABT モード -------

    // SVC モードへ移行しつつ復帰用レジスタを保存する
    srsdb   #HW_PSR_SVC_MODE!   // 例外発生時の PC と CPSR を保存
    cps     #HW_PSR_SVC_MODE

    // SVC モード -------

    // ハンドラを呼び、例外から復帰する
    ldr     lr, =_ZN2nn4kern6ARMv7A15HandleDataAbortEPNS0_3ARM16ExceptionContextE
    push    {ip, lr}
    b       _ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv


// 特権モードだった場合は、
// UserMemoryCopyFunction でアボートが発生したかどうかを調べる
// UserMemoryCopyFunction で発生しているなら、戻り値をセットして
// UserMemoryCopyFunction に戻る
privilege_mode_sequence_data:
    // ABT モード -------

    // 共通スタックを設定し r0-r3 を保存する
    ldr     sp, = NN_KERN_V_ADDR_STACK_CMN_END
    push    {r0-r3}

    // CopyUserMemory のものかどうかをチェック
    // &::nn::kern::svc::BeginUserMemoryCopyFunctionArea <= lr < &::nn::kern::svc::EndUserMemoryCopyFunctionArea
    ldr     r0, =_ZN2nn4kern3ARM31BeginUserMemoryCopyFunctionAreaEv
    cmp     lr, r0
    blo     not_in_user_memory_copy
    ldr     r0, =_ZN2nn4kern3ARM29EndUserMemoryCopyFunctionAreaEv
    cmp     lr, r0
    bhs     not_in_user_memory_copy

in_user_memory_copy:
    pop     {r0-r3}
    msr     spsr_f, #HW_PSR_Z_FLAG      // ループ脱出用にゼロフラグをセット
    mov     r12, #0                     // r12を失敗に上書き
    adds    pc, lr, #4                  // 例外発生の次の命令へ復帰

not_in_user_memory_copy:
    // ハンドラを呼び、例外から復帰する
    ldr     r3, =_ZN2nn4kern6ARMv7A15HandleDataAbortEPNS0_3ARM16ExceptionContextE
    b       _ZN2nn4kern6ARMv7A55CallExceptionHandlerAndReturnFromExceptionPrivilegeModeEv
SET_SIZE(_ZN2nn4kern6ARMv7A16DataAbortHandlerEv)


EXP_VECTOR_ENTRY(_ZN2nn4kern6ARMv7A20PrefetchAbortHandlerEv)
    // ABT モード -------

    sub     lr, lr, #4          // 復帰先は LR - 4

    // 割り込み発生時の状況を調べる
    mov     sp, r0
    mrs     r0, spsr;
    and     r0, r0, #HW_PSR_CPU_MODE_MASK
    cmp     r0, #HW_PSR_USR_MODE
    mov     r0, sp
    bne     privilege_mode_sequence_prefetch

// ユーザモードだった場合
user_mode_sequence_prefetch:
    // ABT モード -------

    // SVC モードへ移行しつつ復帰用レジスタを保存する
    srsdb   #HW_PSR_SVC_MODE!              // 例外発生時の LR と CPSR を保存
    cps     #HW_PSR_SVC_MODE

    // SVC モード -------

    // ハンドラを呼び、例外から復帰する
    ldr     lr, =_ZN2nn4kern6ARMv7A22HandleInstructionAbortEPNS0_3ARM16ExceptionContextE
    push    {ip, lr}
    b       _ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv


// 特権モードだった場合
privilege_mode_sequence_prefetch:
    // 共通スタックを設定し r0-r3 を保存する
    ldr     sp, = NN_KERN_V_ADDR_STACK_CMN_END
    push    {r0-r3}

    // ハンドラを呼び、例外から復帰する
    ldr     r3, =_ZN2nn4kern6ARMv7A22HandleInstructionAbortEPNS0_3ARM16ExceptionContextE
    b       _ZN2nn4kern6ARMv7A55CallExceptionHandlerAndReturnFromExceptionPrivilegeModeEv
SET_SIZE(_ZN2nn4kern6ARMv7A20PrefetchAbortHandlerEv)

