﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../kern_Assembly.h"

ENTRY(_ZN2nn4kern3svc25SvcSendSyncRequestLight64ENS_3svc6HandleE)
    sub     sp, sp, #(4 * 8)
    stp     w1, w2, [sp, #(0 * 8)]
    stp     w3, w4, [sp, #(1 * 8)]
    stp     w5, w6, [sp, #(2 * 8)]
    str     w7,     [sp, #(3 * 8)]
    mov     x1, sp

    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc25SvcSendSyncRequestLight64ENS_3svc6HandleEPj
    ldp     x29, x30, [sp], #16

    ldp     w1, w2, [sp, #(0 * 8)]
    ldp     w3, w4, [sp, #(1 * 8)]
    ldp     w5, w6, [sp, #(2 * 8)]
    ldr     w7,     [sp, #(3 * 8)]
    add     sp, sp, #(4 * 8)
    ret
SET_SIZE(_ZN2nn4kern3svc25SvcSendSyncRequestLight64ENS_3svc6HandleE)

//
//    |
//    +------------
//    |   X7
//    +------------
//    |   X6
//    +------------
//    |   X5
//    +------------
//    |   X4
// SP +------------
//    |
ENTRY(_ZN2nn4kern3svc31SvcSendSyncRequestLight64From32ENS_3svc6HandleE)
    ldp     x4, x5, [sp, #0 * 16]
    ldp     x6, x7, [sp, #1 * 16]

    sub     sp, sp, #(4 * 8)
    stp     w1, w2, [sp, #(0 * 8)]
    stp     w3, w4, [sp, #(1 * 8)]
    stp     w5, w6, [sp, #(2 * 8)]
    str     w7,     [sp, #(3 * 8)]
    mov     x1, sp

    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc31SvcSendSyncRequestLight64From32ENS_3svc6HandleEPj
    ldp     x29, x30, [sp], #16

    ldp     w1, w2, [sp, #(0 * 8)]
    ldp     w3, w4, [sp, #(1 * 8)]
    ldp     w5, w6, [sp, #(2 * 8)]
    ldr     w7,     [sp, #(3 * 8)]
    add     sp, sp, #(4 * 8)

    stp     x4, x5, [sp, #0 * 16]
    stp     x6, x7, [sp, #1 * 16]
    ret
SET_SIZE(_ZN2nn4kern3svc31SvcSendSyncRequestLight64From32ENS_3svc6HandleE)

ENTRY(_ZN2nn4kern3svc25SvcReplyAndReceiveLight64ENS_3svc6HandleE)
    sub     sp, sp, #(4 * 8)
    stp     w1, w2, [sp, #(0 * 8)]
    stp     w3, w4, [sp, #(1 * 8)]
    stp     w5, w6, [sp, #(2 * 8)]
    str     w7,     [sp, #(3 * 8)]
    mov     x1, sp

    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc25SvcReplyAndReceiveLight64ENS_3svc6HandleEPj
    ldp     x29, x30, [sp], #16

    ldp     w1, w2, [sp, #(0 * 8)]
    ldp     w3, w4, [sp, #(1 * 8)]
    ldp     w5, w6, [sp, #(2 * 8)]
    ldr     w7,     [sp, #(3 * 8)]
    add     sp, sp, #(4 * 8)
    ret
SET_SIZE(_ZN2nn4kern3svc25SvcReplyAndReceiveLight64ENS_3svc6HandleE)

ENTRY(_ZN2nn4kern3svc31SvcReplyAndReceiveLight64From32ENS_3svc6HandleE)
    ldp     x4, x5, [sp, #0 * 16]
    ldp     x6, x7, [sp, #1 * 16]

    sub     sp, sp, #(4 * 8)
    stp     w1, w2, [sp, #(0 * 8)]
    stp     w3, w4, [sp, #(1 * 8)]
    stp     w5, w6, [sp, #(2 * 8)]
    str     w7,     [sp, #(3 * 8)]
    mov     x1, sp

    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc31SvcReplyAndReceiveLight64From32ENS_3svc6HandleEPj
    ldp     x29, x30, [sp], #16

    ldp     w1, w2, [sp, #(0 * 8)]
    ldp     w3, w4, [sp, #(1 * 8)]
    ldp     w5, w6, [sp, #(2 * 8)]
    ldr     w7,     [sp, #(3 * 8)]
    add     sp, sp, #(4 * 8)

    stp     x4, x5, [sp, #0 * 16]
    stp     x6, x7, [sp, #1 * 16]
    ret
SET_SIZE(_ZN2nn4kern3svc31SvcReplyAndReceiveLight64From32ENS_3svc6HandleE)

