﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../../kern_KThread.h"

namespace nn { namespace kern {
namespace ARM64 {
    struct ExceptionContext
    {
        Bit64       x[31];      // r0 - r30
        Bit64       sp;
        Bit64       pc;
        Bit32       psr;
        Bit32       write;
        Bit64       tpidr;
        Bit64       padding;
    };

    inline const ExceptionContext* GetExceptionContext(const KThread* pThread)
    {
        return reinterpret_cast<const ExceptionContext*>(reinterpret_cast<uintptr_t>(
                    pThread->GetKernelStackBottom()) - sizeof(KThread::ParamsOnStack) - sizeof(ExceptionContext));
    }
    inline ExceptionContext* GetExceptionContext(KThread* pThread)
    {
        return reinterpret_cast<ExceptionContext*>(reinterpret_cast<uintptr_t>(
                    pThread->GetKernelStackBottom()) - sizeof(KThread::ParamsOnStack) - sizeof(ExceptionContext));
    }
}
}}

