﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../ARM/kern_Assembly.h"
#include "kern_AssemblyOffset.h"

ENTRY(_ZN2nn4kern3ARM31BeginUserMemoryCopyFunctionAreaEv)
SET_SIZE(_ZN2nn4kern3ARM31BeginUserMemoryCopyFunctionAreaEv)

ENTRY(_ZN2nn4kern3ARM18CopyMemoryFromUserEPvPKvj)
//bool CopyMemoryFromUser(void*, const void*, size_t)
// void* dstKernel, const void* srcUser, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

loopCopyMemoryFromUser:
    ldrbt   r2, [r1], #1
    cmpne   r1, r3          // ldrbtが 失敗したしたときは実行しない。
    strb    r2, [r0], #1
    bne     loopCopyMemoryFromUser

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM18CopyMemoryFromUserEPvPKvj)

ENTRY(_ZN2nn4kern3ARM24CopyMemoryFromUserAlign4EPvPKvj)
//bool CopyMemoryFromUserAlign4(void*, const void*, size_t)
// void* dstKernel, const void* srcUser, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    orr     r3, r0, r1
    orr     r3, r3, r2
    tst     r3, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer, srcPointer, or length not 4-byte aligned
NN_LSYM(0)
    mrs     r3, cpsr
    bic     r3, #HW_PSR_Z_FLAG
    msr     cpsr_f, r3
#endif

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

loopCopyMemoryFromUserAlign4:
    ldrt    r2, [r1], #4
    cmpne   r1, r3          // ldrtが 失敗したしたときは実行しない。
    str     r2, [r0], #4
    bne     loopCopyMemoryFromUserAlign4

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM24CopyMemoryFromUserAlign4EPvPKvj)

ENTRY(_ZN2nn4kern3ARM23CopyMemoryFromUserOnly4EPvPKv)
// bool CopyMemoryFromUserOnly4(void*, const void*)
// void* dstKernel, const void* srcUser

    // r0: dstPointer
    // r1: srcPointer (user)

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    orr     r3, r0, r1
    tst     r3, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer or srcPointer not 4-byte aligned
NN_LSYM(0)
#endif

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    ldrt    r2, [r1]
    str     r2, [r0]

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM23CopyMemoryFromUserOnly4EPvPKv)

ENTRY(_ZN2nn4kern3ARM18CopyStringFromUserEPvPKvj)
//int32_t CopyStringFromUser(void*, const void*, size_t)
// void* dstKernel, const void* srcUser, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd
    // r4: srcBase

    cmp     r2, #0
    moveq   r0, #0
    bxeq    lr

    push    {r4, lr}    // 例外に到達した場合、lrが書き換えられる

    mov     r4, r1
    mov     r12, #1
    add     r3, r1, r2

    // r2: temp
    // cpsr[Z] = 0

loopCopyStringFromUser:
    ldrbt   r2, [r1], #1
    cmpne   r1, r3          // ldrbtが 失敗したしたときは実行しない。
    strb    r2, [r0], #1
    cmpne   r2, #0
    bne     loopCopyStringFromUser

    cmp     r12, #0
    moveq   r0, #0
    subne   r0, r1, r4

    pop     {r4, pc}
SET_SIZE(_ZN2nn4kern3ARM18CopyStringFromUserEPvPKvj)

ENTRY(_ZN2nn4kern3ARM16CopyMemoryToUserEPvPKvj)
//bool CopyMemoryToUser(void*, const void*, size_t)
// void* dstUser, const void* srcKernel, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp

loopCopyMemoryToUser:
    ldrb    r2, [r1], #1
    cmp     r1, r3
    strbt   r2, [r0], #1
    bne     loopCopyMemoryToUser

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM16CopyMemoryToUserEPvPKvj)

ENTRY(_ZN2nn4kern3ARM22CopyMemoryToUserAlign4EPvPKvj)
//bool CopyMemoryToUserAlign4(void*, const void*, size_t)
// void* dstUser, const void* srcKernel, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: dstEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    orr     r3, r0, r1
    orr     r3, r3, r2
    tst     r3, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer, srcPointer, or length not 4-byte aligned
NN_LSYM(0)
#endif

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp

loopCopyMemoryToUserAlign4:
    ldr     r2, [r1], #4
    cmp     r1, r3
    strt    r2, [r0], #4
    bne     loopCopyMemoryToUserAlign4

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM22CopyMemoryToUserAlign4EPvPKvj)

ENTRY(_ZN2nn4kern3ARM21CopyMemoryToUserOnly4EPvPKv)
//bool CopyMemoryToUserOnly4(void*, const void*)
// void* dstUser, const void* srcKernel

    // r0: dstPointer
    // r1: srcPointer (user)

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    orr     r3, r0, r1
    tst     r3, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer or srcPointer not 4-byte aligned
NN_LSYM(0)
#endif

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    ldr     r2, [r1]
    strt    r2, [r0]

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM21CopyMemoryToUserOnly4EPvPKv)

ENTRY(_ZN2nn4kern3ARM16CopyStringToUserEPvPKvj)
//int32_t CopyStringToUser(void*, const void*, size_t)
// void* dstUser, const void* srcKernel, size_t length

    // r0: dstPointer
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd
    // r4: srcBase

    cmp     r2, #0
    moveq   r0, #0
    bxeq    lr

    push    {r4, lr}    // 例外に到達した場合、lrが書き換えられる

    mov     r4, r0
    mov     r12, #1
    add     r3, r1, r2

    // r2: temp

loopCopyStringToUser:
    ldrb    r2, [r1], #1
    cmp     r1, r3
    strbt   r2, [r0], #1
    cmpne   r2, #0
    bne     loopCopyStringToUser

    cmp     r12, #0
    moveq   r0, #0
    subne   r0, r1, r4

    pop     {r4, pc}
SET_SIZE(_ZN2nn4kern3ARM16CopyStringToUserEPvPKvj)

ENTRY(_ZN2nn4kern3ARM15ClearUserMemoryEPvj)
//bool ClearUserMemory(void*, size_t)
// void* dstUser, size_t length

    // r0: dstPointer
    // r1: length
    // r2: -
    // r3: dstEnd

    cmp     r1, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r0, r1

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: 0
    mov     r2, #0

loopClearUserMemory:
    strbt   r2, [r0], #1
    cmpne   r0, r3
    bne     loopClearUserMemory

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM15ClearUserMemoryEPvj)

ENTRY(_ZN2nn4kern3ARM21ClearUserMemoryAlign4EPvj)
//bool ClearUserMemoryAlign4(void*, size_t)
// void* dstUser, size_t length

    // r0: dstPointer
    // r1: length
    // r2: -
    // r3: dstEnd

    cmp     r1, #0
    moveq   r0, #1
    bxeq    lr

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    orr     r3, r0, r1
    orr     r3, r3, r2
    tst     r3, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer, srcPointer, or length not 4-byte aligned
NN_LSYM(0)
#endif

    mov     r12, #1
    add     r3, r0, r1

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: 0
    mov     r2, #0

loopClearUserMemoryAlign4:
    strt    r2, [r0], #4
    cmpne   r0, r3
    bne     loopClearUserMemoryAlign4

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM21ClearUserMemoryAlign4EPvj)

ENTRY(_ZN2nn4kern3ARM20ClearUserMemoryOnly4EPv)
//bool ClearUserMemoryOnly4(void*)
// void* dstUser

    // r0: dstPointer

#if NN_BUILD_DEBUG_OR_NN_BUILD_DEVELOPMENT == 1
    tst     r0, #3
    beq     NN_FSYM(0)
    bkpt    0       // dstPointer not 4-byte aligned
NN_LSYM(0)
#endif

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    mov     r2, #0
    strt    r2, [r0]

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM20ClearUserMemoryOnly4EPv)

ENTRY(_ZN2nn4kern3ARM14StoreDataCacheEjj)
//bool StoreDataCache(uintptr_t begin, uintptr_t end)
    cmp     r0, r1
    bxeq    lr

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // cpsr[Z] = 0
loopStoreDataCache:
    mcr     p15, 0, r0, c7, c10, 1
    addne   r0, r0, #DATA_CACHE_LINE_SIZE
    cmpne   r1, r0
    bne     loopStoreDataCache

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM14StoreDataCacheEjj)

ENTRY(_ZN2nn4kern3ARM14FlushDataCacheEjj)
//bool FlushDataCache(uintptr_t begin, uintptr_t end)
    cmp     r0, r1
    bxeq    lr

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // cpsr[Z] = 0
loopFlushDataCache:
    mcr     p15, 0, r0, c7, c14, 1
    addne   r0, r0, #DATA_CACHE_LINE_SIZE
    cmpne   r1, r0
    bne     loopFlushDataCache

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM14FlushDataCacheEjj)

ENTRY(_ZN2nn4kern3ARM19InvalidateDataCacheEjj)
//bool InvalidateDataCache(uintptr_t begin, uintptr_t end)
    cmp     r0, r1
    bxeq    lr

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // cpsr[Z] = 0
loopInvalidateDataCache:
    mcr     p15, 0, r0, c7, c6, 1
    addne   r0, r0, #DATA_CACHE_LINE_SIZE
    cmpne   r1, r0
    bne     loopInvalidateDataCache

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM19InvalidateDataCacheEjj)

ENTRY(_ZN2nn4kern3ARM26InvalidateInstructionCacheEjj)
//bool InvalidateInstructionCache(uintptr_t begin, uintptr_t end)
    cmp     r0, r1
    bxeq    lr

    mov     r12, #1
    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // cpsr[Z] = 0
loopInvalidateInstructionCache:
    mcr     p15, 0, r0, c7, c5, 1
    addne   r0, r0, #INSTRUCTION_CACHE_LINE_SIZE
    cmpne   r1, r0
    bne     loopInvalidateInstructionCache

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM26InvalidateInstructionCacheEjj)

ENTRY(_ZN2nn4kern3ARM14ReadIoMemory32EPvPKvj)
//bool ReadIoMemory32(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrt    r2, [r1], #4
    dsb     sy
    nop
    moveq   r2, #0xffffffff
    moveq   r12, #1
    cmp     r1, r3
    strt    r2, [r0], #4
    bne     1b

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM14ReadIoMemory32EPvPKvj)

ENTRY(_ZN2nn4kern3ARM14ReadIoMemory16EPvPKvj)
//bool ReadIoMemory16(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrht   r2, [r1], #2
    dsb     sy
    nop
    moveq   r2, #0xffffffff
    moveq   r12, #1
    cmp     r1, r3
    strht   r2, [r0], #2
    bne     1b

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM14ReadIoMemory16EPvPKvj)

ENTRY(_ZN2nn4kern3ARM13ReadIoMemory8EPvPKvj)
//bool ReadIoMemory8(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrbt   r2, [r1], #1
    dsb     sy
    nop
    moveq   r2, #0xffffffff
    moveq   r12, #1
    cmp     r1, r3
    strbt   r2, [r0], #1
    bne     1b

    mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM13ReadIoMemory8EPvPKvj)

ENTRY(_ZN2nn4kern3ARM15WriteIoMemory32EPvPKvj)
//bool WriteIoMemory32(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrt    r2, [r1], #4
    beq     2f
    strt    r2, [r0], #4
    dsb     sy
    nop
    mov     r12, #1
    cmp     r1, r3
    bne     1b

2:  mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM15WriteIoMemory32EPvPKvj)

ENTRY(_ZN2nn4kern3ARM15WriteIoMemory16EPvPKvj)
//bool WriteIoMemory16(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrht   r2, [r1], #2
    beq     2f
    strht   r2, [r0], #2
    dsb     sy
    nop
    mov     r12, #1
    cmp     r1, r3
    bne     1b

2:  mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM15WriteIoMemory16EPvPKvj)

ENTRY(_ZN2nn4kern3ARM14WriteIoMemory8EPvPKvj)
//bool WriteIoMemory8(void*, const void*, size_t)

    // r0: dstPointer (user)
    // r1: srcPointer (user)
    // r2: length
    // r3: srcEnd

    cmp     r2, #0
    moveq   r0, #1
    bxeq    lr

    mov     r12, #1
    add     r3, r1, r2

    push    {lr}    // 例外に到達した場合、lrが書き換えられる

    // r2: temp
    // cpsr[Z] = 0

1:  ldrbt   r2, [r1], #1
    beq     2f
    strbt   r2, [r0], #1
    dsb     sy
    nop
    mov     r12, #1
    cmp     r1, r3
    bne     1b

2:  mov     r0, r12
    pop     {pc}
SET_SIZE(_ZN2nn4kern3ARM14WriteIoMemory8EPvPKvj)

ENTRY(_ZN2nn4kern3ARM29EndUserMemoryCopyFunctionAreaEv)
nop
SET_SIZE(_ZN2nn4kern3ARM29EndUserMemoryCopyFunctionAreaEv)

