﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../../kern_KThread.h"

namespace nn { namespace kern {
namespace ARM {
    struct ExceptionContext
    {
        Bit32       r[12];      // r0 - r11
        Bit32       sp_usr;
        Bit32       lr_usr;
        Bit32       tpidr;
        Bit32       padding;
        Bit32       ip;
        Bit32       write;      // svc のときは全部レジスタを書き戻すかどうか(それ以外は padding)
                                // abort のときは 呼び出されるハンドラのアドレス
        Bit32       pc;
        Bit32       cpsr;
    };

    inline const ExceptionContext* GetExceptionContext(const KThread* pThread)
    {
        return reinterpret_cast<const ExceptionContext*>(reinterpret_cast<uintptr_t>(
                    pThread->GetKernelStackBottom()) - sizeof(KThread::ParamsOnStack) - sizeof(ExceptionContext));
    }
    inline ExceptionContext* GetExceptionContext(KThread* pThread)
    {
        return reinterpret_cast<ExceptionContext*>(reinterpret_cast<uintptr_t>(
                    pThread->GetKernelStackBottom()) - sizeof(KThread::ParamsOnStack) - sizeof(ExceptionContext));
    }
}
}}

