﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../../ip/ARM64/kern_Assembly.h"
#include "../../ip/ARM64/kern_RegisterDefinition.h"

#define LOAD_IMMEDIATE_VALUE(reg, value)                    \
    mov     reg, #((value) & 0xffff);                       \
    movk    reg, #(((value) >> 16) & 0xffff), lsl #16;      \
    movk    reg, #(((value) >> 32) & 0xffff), lsl #32;      \
    movk    reg, #(((value) >> 48) & 0xffff), lsl #48

    .section ".text"
    .balign  4096

#define PSCI_POWER_STATE_SC7    0x0201001B
ENTRY(_ZN2nn4kern14KSystemControl15CpuSleepHandlerEmm)
    mov     x17, x0
    mov     x18, x1
    mrs     x1, cpacr_el1
    orr     x1, x1, #HW_CPACR_EL1_FEN_EL1_ENABLE
    msr     cpacr_el1, x1
    dsb     sy
    isb

    stp     x19, x20, [x0], #16
    stp     x21, x22, [x0], #16
    stp     x23, x24, [x0], #16
    stp     x25, x26, [x0], #16
    stp     x27, x28, [x0], #16
    stp     x29, x30, [x0], #16
    mov     x1, sp
    str     x1,       [x0], #8
    mrs     x1, fpcr
    mrs     x2, fpsr
    stp     w1, w2,   [x0], #8

    // バッファの先頭から 16Byte アラインになっているようにする
    stp     q0, q1,   [x0], #32
    stp     q2, q3,   [x0], #32
    stp     q4, q5,   [x0], #32
    stp     q6, q7,   [x0], #32
    stp     q8, q9,   [x0], #32
    stp     q10, q11, [x0], #32
    stp     q12, q13, [x0], #32
    stp     q14, q15, [x0], #32
    stp     q16, q17, [x0], #32
    stp     q18, q19, [x0], #32
    stp     q20, q21, [x0], #32
    stp     q22, q23, [x0], #32
    stp     q24, q25, [x0], #32
    stp     q26, q27, [x0], #32
    stp     q28, q29, [x0], #32
    stp     q30, q31, [x0], #32
    mrs     x1, s3_1_c15_c2_1   // cpuectlr_el1
    mrs     x2, s3_1_c15_c2_0   // cpuactlr_el1
    stp     x1, x2,   [x0], #16
    mrs     x1, ttbr0_el1
    mrs     x2, ttbr1_el1
    stp     x1, x2,   [x0], #16
    mrs     x1, tcr_el1
    mrs     x2, mair_el1
    stp     x1, x2,   [x0], #16
    mrs     x1, sctlr_el1
    mrs     x2, tpidr_el1
    stp     x1, x2,  [x0], #16
    adr     x1, .LResumeVirtual
    stp     x1, xzr, [x0], #16

    mrs     x0, mpidr_el1
    and     x0, x0, #(HW_MPIDR_EL1_AFF0_MASK)
    cbz     x0, .L_Suspend

    LOAD_IMMEDIATE_VALUE(x0, 0x84000002)
    smc     #1
1:  b       1b

.L_Suspend:
    LOAD_IMMEDIATE_VALUE(x0, 0xC4000001)
    LOAD_IMMEDIATE_VALUE(x1, PSCI_POWER_STATE_SC7)
    mov     x2, x18
    mov     x3, x17
    smc     #1
1:  b       1b

.LCleanInvalidateDataCache:
    lsl     x8, x0, #1
    msr     csselr_el1, x8
    isb
    mrs     x13, ccsidr_el1
    ubfx    w10, w13, #3, #10
    and     w11, w13, #0x7
    ubfx    w13, w13, #13, #15
    mov     w9, wzr
    add     w11, w11, #0x4
    clz     w12, w10
    add     w13, w13, #0x1
1:  mov     w14, wzr
    lsl     w15, w9, w12
2:  lsl     w16, w14, w11
    add     w14, w14, #0x1
    orr     w16, w16, w15
    sxtw    x16, w16
    orr     x16, x16, x8
    dc      cisw, x16
    cmp     w13, w14
    b.ne    2b
    cmp     w9, w10
    add     w9, w9, #0x1
    b.ne    1b
    dsb     sy
    isb
    ret
SET_SIZE(_ZN2nn4kern14KSystemControl15CpuSleepHandlerEmm)

ENTRY(_ZN2nn4kern14KSystemControl11ResumeEntryEm)
    msr     daifset, #0xF
    mov     x21, x0

    mrs     x0, CurrentEL
    cmp     x0, #0x4
    b.eq    3f

    cmp     x2, #0x8
    b.eq    2f

    // EL3
1:  b       1b

    // EL2
2:  b       2b

    // EL1
3:

    // L1 Cache Invalidate
    mov     x0, #0
    bl      .LInvalidateDataCache

    mrs     x0, mpidr_el1
    and     x0, x0, #(HW_MPIDR_EL1_AFF0_MASK)
    cbnz    x0, 4f

    // L2 Cache Invalidate
    mov     x0, #1
    bl      .LInvalidateDataCache

4:
    // L1 Cache Invalidate
    mov     x0, #0
    bl      .LInvalidateDataCache

    // 命令キャッシュ 無効化
    ic      ialluis
    dsb     sy
    isb

    // TLB 無効化
    tlbi    vmalle1is
    dsb     sy
    isb

    msr     SPSel, #1
    mov     x0, x21

    mrs     x1, cpacr_el1
    orr     x1, x1, #HW_CPACR_EL1_FEN_EL1_ENABLE
    msr     cpacr_el1, x1
    dsb     sy
    isb

    ldp     x19, x20, [x0], #16
    ldp     x21, x22, [x0], #16
    ldp     x23, x24, [x0], #16
    ldp     x25, x26, [x0], #16
    ldp     x27, x28, [x0], #16
    ldp     x29, x30, [x0], #16
    ldr     x1,       [x0], #8
    mov     sp, x1

    ldp     w1, w2,   [x0], #8
    msr     fpcr, x1
    msr     fpsr, x2

    // バッファの先頭から 16Byte アラインになっているようにする
    ldp     q0, q1,   [x0], #32
    ldp     q2, q3,   [x0], #32
    ldp     q4, q5,   [x0], #32
    ldp     q6, q7,   [x0], #32
    ldp     q8, q9,   [x0], #32
    ldp     q10, q11, [x0], #32
    ldp     q12, q13, [x0], #32
    ldp     q14, q15, [x0], #32
    ldp     q16, q17, [x0], #32
    ldp     q18, q19, [x0], #32
    ldp     q20, q21, [x0], #32
    ldp     q22, q23, [x0], #32
    ldp     q24, q25, [x0], #32
    ldp     q26, q27, [x0], #32
    ldp     q28, q29, [x0], #32
    ldp     q30, q31, [x0], #32
    ldp     x1, x2,   [x0], #16
    msr     s3_1_c15_c2_1, x1    // cpuectlr_el1
    msr     s3_1_c15_c2_0, x2    // cpuactlr_el1
    ldp     x1, x2,   [x0], #16
    msr     ttbr0_el1, x1
    msr     ttbr1_el1, x2
    ldp     x1, x2,   [x0], #16
    msr     tcr_el1, x1
    msr     mair_el1, x2
    ldp     x1, x2,  [x0], #16
    ldp     x3, xzr, [x0], #16
    // Current アクセスに必要 (tpidr_el1, x18)
    msr     tpidr_el1, x2
    mov     x18, x2
    dsb     sy
    isb

    bic     x2, x1, #HW_SCTLR_WXN
    msr     sctlr_el1, x2
    dsb     sy
    isb

    br      x3
.LResumeVirtual:
    msr     sctlr_el1, x1
    dsb     sy
    isb

    ret

.LInvalidateDataCache:
    lsl     x8, x0, #1
    msr     csselr_el1, x8
    isb
    mrs     x13, ccsidr_el1
    ubfx    w10, w13, #3, #10
    and     w11, w13, #0x7
    ubfx    w13, w13, #13, #15
    mov     w9, wzr
    add     w11, w11, #0x4
    clz     w12, w10
    add     w13, w13, #0x1
1:  mov     w14, wzr
    lsl     w15, w9, w12
2:  lsl     w16, w14, w11
    add     w14, w14, #0x1
    orr     w16, w16, w15
    sxtw    x16, w16
    orr     x16, x16, x8
    dc      isw, x16
    cmp     w13, w14
    b.ne    2b
    cmp     w9, w10
    add     w9, w9, #0x1
    b.ne    1b
    dsb     sy
    isb
    ret
SET_SIZE(_ZN2nn4kern14KSystemControl11ResumeEntryEm)


