﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include <nn/nn_BitTypes.h>
#include <nn/util/util_BitPack.h>
#include "../../kern_Platform.h"

namespace nn { namespace kern { namespace NX {
namespace smc {

enum ConfigItem
{
    ConfigItem_DisableDescVerification  = 1,
    ConfigItem_DramId                   = 2,
    ConfigItem_InterruptNumber          = 3,
    ConfigItem_FuseVersion              = 4,
    ConfigItem_HardwareType             = 5,
    ConfigItem_HardwareState            = 6,
    ConfigItem_IsRecoveryBoot           = 7,
    ConfigItem_DeviceId                 = 8,
    ConfigItem_BootReason               = 9,
    ConfigItem_MemoryMode               = 10,
    ConfigItem_IsDevelopmentFunctionEnabled = 11,
    ConfigItem_KernelFlags              = 12,
};

enum MemorySize
{
    MemorySize_4G    = 0,
    MemorySize_6G,
    MemorySize_8G,
};

struct KernelFlags
{
    typedef nn::util::BitPack32::Field<0,                                 1, bool>   EnableNonZeroFillMemory;
    typedef nn::util::BitPack32::Field<EnableNonZeroFillMemory::Next,     1, bool>   EnableUserExceptionHandler;
    typedef nn::util::BitPack32::Field<EnableUserExceptionHandler::Next,  1, bool>   EnablePmuAccess;
    typedef nn::util::BitPack32::Field<EnablePmuAccess::Next,             5, Bit32>  Reserved0;
    typedef nn::util::BitPack32::Field<Reserved0::Next,                   1, bool>   CallShowErrorOnPanic;
    typedef nn::util::BitPack32::Field<CallShowErrorOnPanic::Next,        7, Bit32>  Reserved1;
    typedef nn::util::BitPack32::Field<Reserved1::Next,                   2, Bit32>  MemorySize;
    typedef nn::util::BitPack32::Field<MemorySize::Next,                 14, Bit32>  Reserved2;
};



struct ConfigItemData
{
    Bit64 data[4];
};

void SecureMonitorCall(Bit64* pBuf);
void CpuOn(Bit64 cpuId, Bit64 entryPoint, Bit64 contextId);
void GenerateRandomBytes(void* pBuffer, size_t size);
void GetConfig(ConfigItemData* pData, ConfigItem item);
void ShowError(Bit32 color);
void SetKernelCarveoutRegion(int index, uintptr_t address, size_t size);
bool ReadWriteRegister(Bit32 *pOut, uint64_t address, Bit32 mask, Bit32 value);

}

}}}

