﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   チックに関する C 言語用 API の宣言
 */

#pragma once

#include <stdint.h>
#include <nnc/nn_Macro.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_TickTypes.h>
#include <nnc/os/detail/os_MacroImpl.h>

//--------------------------------------------------------------------------
//  C 言語向けの宣言
//--------------------------------------------------------------------------

//! @name 時間管理関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   システムチック値を取得します。
 *
 * @details
 *  詳細は nn::os::GetSystemTick() を参照して下さい。
 *
 */
NN_OS_EXTERN_C nnosTick  nnosGetSystemTick();


//--------------------------------------------------------------------------
/**
 * @brief   システムチック値の周波数を取得します。
 *
 * @details
 *  詳細は nn::os::GetSystemTickFrequency() を参照して下さい。
 *
 */
NN_OS_EXTERN_C int64_t nnosGetSystemTickFrequency();


//--------------------------------------------------------------------------
/**
 * @brief   システムチックをナノ秒に変換して返します。
 *
 * @details
 *  詳細は nn::os::ConvertToTimeSpan() を参照して下さい。
 *
 */
NN_OS_EXTERN_C int64_t  nnosConvertTickToNanoSeconds(nnosTick tick);


//--------------------------------------------------------------------------
/**
 * @brief   ナノ秒をシステムチックに変換して返します。
 *
 * @details
 *  詳細は nn::os::ConvertToTick() を参照して下さい。
 *
 */
NN_OS_EXTERN_C nnosTick    nnosConvertNanoSecondsToTick(int64_t nanoSeconds);


//! @}
