﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   コンパイラのスレッドローカル実装用 API の宣言
 */

#pragma once

#include <nnc/nn_Common.h>

//  リファレンスの詳細は nn/os/os_SdkMemoryAllocatorForThreadLocal.h にある
//  同名の関数のリファレンスを参照して下さい。
//
//  Please refer to the explanation of the functions, which have the same name
//  as the following APIs, in "nn/os/os_SdkMemoryAllocatorForThreadLocal.h".

void* nnosAllocateMemoryForThreadLocal(size_t size);
void  nnosFreeMemoryForThreadLocal(void* address, size_t size);
int   nnosGetModuleCountMax(void);

//! @}

