﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ハンドルを扱う C 言語用の API の宣言
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/nn_Macro.h>
#include <nnc/os/os_NativeHandleTypes.h>

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

//! @name ハンドル関連共通 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   指定されたハンドルをクローズします。
 *
 * @details
 *  詳細は nn::os::CloseNativeHandle() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosCloseNativeHandle(nnosNativeHandle handle);

//! @}
