﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   割込みイベントに関する C 言語用 API の宣言
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_EventCommon.h>
#include <nnc/os/os_InterruptEventCommon.h>
#include <nnc/os/os_InterruptEventTypes.h>
#include <nnc/os/os_MultipleWaitTypes.h>
#include <nnc/os/detail/os_MacroImpl.h>

//---------------------------------------------------------------------------
//  C 向けの宣言
//---------------------------------------------------------------------------

//! @name 割込みイベント関連 C 言語用 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトを初期化します。
 *
 * @details
 *  詳細は nn::os::InitializeInterruptEvent() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosInitializeInterruptEvent(nnosInterruptEventType* event, nnosInterruptName interruptName, nnosEventClearMode clearMode);


//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトを破棄します。
 *
 * @details
 *  詳細は nn::os::FinalizeInterruptEvent() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosFinalizeInterruptEvent(nnosInterruptEventType* event);


//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトがシグナル状態になるまで待機します。
 *
 * @details
 *  詳細は nn::os::WaitInterruptEvent() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosWaitInterruptEvent(nnosInterruptEventType* event);


//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトがシグナル状態かをポーリングします。
 *
 * @details
 *  詳細は nn::os::TryWaitInterruptEvent() を参照して下さい。
 *
 */
NN_OS_EXTERN_C bool nnosTryWaitInterruptEvent(nnosInterruptEventType* event);


//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトがシグナル状態になるまで時限付きで待機します。
 *
 * @details
 *  詳細は nn::os::TimedWaitInterruptEvent() を参照して下さい。@n
 *  本 API では、タイムアウト時間をナノ秒単位で指定します。
 *
 */
NN_OS_EXTERN_C bool nnosTimedWaitInterruptEvent(nnosInterruptEventType* event, int64_t timeout);


//--------------------------------------------------------------------------
/**
 * @brief   nnosInterruptEventType オブジェクトを非シグナル状態にクリアします。
 *
 * @details
 *  詳細は nn::os::ClearInterruptEvent() を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosClearInterruptEvent(nnosInterruptEventType* event);

//! @}


//! @name 多重待ち関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   multiWaitHolder を初期化し、interruptEvent と関連付けます。
 *
 * @details
 *  詳細は nn::os::InitializeMultiWaitHolder(MultiWaitHolderType* multiWaitHolder, InterruptEventType* interruptEvent) を参照して下さい。
 *
 */
NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForInterruptEvent(nnosMultiWaitHolderType* multiWaitHolder, nnosInterruptEventType* interruptEvent);

//! @}

