﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#ifndef __cplusplus

#if defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_32)
//--------------------------------------------------------------------------
// 静的に初期化された MutexType オブジェクトを Win32 用に配置します。
//
#define NN_OS_MUTEX_INITIALIZER(recursive)                              \
        {                                                               \
            1, /* nn::os::MutexType::State::State_Initialized */        \
            (recursive),                                                \
            0,                                                          \
            0,                                                          \
            0, 0, 0, 0, /* int _lockLevel */                            \
            0, 0, 0, 0, /* int _nestCount */                            \
            0, 0, 0, 0, /* ThreadType* _ownerThread */                  \
            /* ::CriticalSection */                                     \
                0xff, 0xff, 0xff, 0xff,                                 \
                0xff, 0xff, 0xff, 0xff,                                 \
                0,    0,    0,    0,                                    \
                0,    0,    0,    0,                                    \
                0,    0,    0,    0,                                    \
                0,    0,    0,    0,                                    \
        }
//--------------------------------------------------------------------------
#elif defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_64)
//--------------------------------------------------------------------------
// 静的に初期化された MutexType オブジェクトを Win64 用に配置します。
//
#define NN_OS_MUTEX_INITIALIZER(recursive)                              \
        {                                                               \
            1, /* nn::os::MutexType::State::State_Initialized */        \
            (recursive),                                                \
            0,                                                          \
            0,                                                          \
            0, 0, 0, 0, /* int _lockLevel */                            \
            0, 0, 0, 0, /* int _nestCount */                            \
            0, 0, 0, 0, /* padding */                                   \
            0, 0, 0, 0, 0, 0, 0, 0, /* ThreadType* _ownerThread */      \
            /* ::CriticalSection */                                     \
                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,         \
                0xff, 0xff, 0xff, 0xff,                                 \
                0,    0,    0,    0,                                    \
                0,    0,    0,    0,    0,    0,    0,    0,            \
                0,    0,    0,    0,    0,    0,    0,    0,            \
                0,    0,    0,    0,    0,    0,    0,    0,            \
        }
//--------------------------------------------------------------------------
#endif

#endif  // __cplusplus


