﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   OS-API 内部実装用のメモリフェンスの定義（Horizon 版）
 */

#pragma once

#include <nn/os/os_Config.h>

#include <nnc/nn_Common.h>
#include <nnc/nn_Macro.h>

#if defined(NN_BUILD_CONFIG_CPU_ARM_V7A)
    #define NNC_OS_DMB_ISHST()   asm volatile ("dmb ishst" : : : "memory")
    #define NNC_OS_DMB_ISHLD()   asm volatile ("dmb ish"   : : : "memory")
    #define NNC_OS_DMB_ISH()     asm volatile ("dmb ish"   : : : "memory")
#elif defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    #define NNC_OS_DMB_ISHST()   asm volatile ("dmb ishst" : : : "memory")
    #define NNC_OS_DMB_ISHLD()   asm volatile ("dmb ishld" : : : "memory")
    #define NNC_OS_DMB_ISH()     asm volatile ("dmb ish"   : : : "memory")
#elif defined(NN_BUILD_CONFIG_CPU_ARM)
    #define NNC_OS_DMB_ISHST()   asm volatile ("dmb" : : : "memory")
    #define NNC_OS_DMB_ISHLD()   asm volatile ("dmb" : : : "memory")
    #define NNC_OS_DMB_ISH()     asm volatile ("dmb" : : : "memory")
#else
    #error "指定されたビルド対象の CPU が ARM 系ではありません。"
#endif

//--------------------------------------------------------------------------

#ifndef __cplusplus

static NNC_FORCEINLINE void nnosdetailFenceMemoryStoreStore()
{
    NNC_OS_DMB_ISHST();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryStoreLoad()
{
    NNC_OS_DMB_ISH();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryStoreAny()
{
    NNC_OS_DMB_ISH();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryLoadStore()
{
    NNC_OS_DMB_ISHLD();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryLoadLoad()
{
    NNC_OS_DMB_ISHLD();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryLoadAny()
{
    NNC_OS_DMB_ISHLD();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryAnyStore()
{
    NNC_OS_DMB_ISH();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryAnyLoad()
{
    NNC_OS_DMB_ISH();
}

static NNC_FORCEINLINE void nnosdetailFenceMemoryAnyAny()
{
    NNC_OS_DMB_ISH();
}

#endif // __cplusplus

//--------------------------------------------------------------------------
