﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#ifndef __cplusplus

#if 1
#if defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_32)
//--------------------------------------------------------------------------
// 静的に初期化された ConditionVariableType オブジェクトを Win32 用に配置
// ::InitializeConditionVariable() 相当の静的初期化版はこちら。
//
#define NN_OS_CONDITION_VARIABLE_INITIALIZER()                              \
        {                                                                   \
            1, /* nn::os::ConditionVariableType::State_Initialized */       \
               0, /* _needLazyInitialize = false */                         \
                  0, 0, /* padding */                                       \
            0, 0, 0, 0, /* CONDITION_VARIABLE */                            \
            0, 0, 0, 0, /* _padding           */                            \
        }

//--------------------------------------------------------------------------
#elif defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_64)
//--------------------------------------------------------------------------
// 静的に初期化された ConditionVariableType オブジェクトを Win64 用に配置
// ::InitializeConditionVariable() 相当の静的初期化版はこちら。
//
#define NN_OS_CONDITION_VARIABLE_INITIALIZER()                              \
        {                                                                   \
            1, /* nn::os::ConditionVariableType::State_Initialized */       \
               0, 0, 0,             /* padding */                           \
                        0, 0, 0, 0, /* _needLazyInitialize = false */       \
            0, 0, 0, 0, 0, 0, 0, 0, /* CONDITION_VARIABLE */                \
            0, 0, 0, 0, 0, 0, 0, 0, /* _padding           */                \
        }

//--------------------------------------------------------------------------
#endif
#else
#if defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_32)
//--------------------------------------------------------------------------
// 静的に初期化された ConditionVariableType オブジェクトを Win32 用に配置
// std::condition_variable_any 使用時の LazyInitialize 版はこちら。
//
#define NN_OS_CONDITION_VARIABLE_INITIALIZER()                              \
        {                                                                   \
            0, /* nn::os::ConditionVariableType::State_NotInitialized */    \
               1, /* _needLazyInitialize = true */                          \
                  0, 0, /* padding */                                       \
            0, 0, 0, 0, /* _Cnd_t in std::condition_variable_any */         \
            0, 0, 0, 0, /* _Mtx_t in std::condition_variable_any */         \
        }

//--------------------------------------------------------------------------
#elif defined(NN_BUILD_CONFIG_OS_WIN32) && defined(NN_BUILD_CONFIG_ADDRESS_64)
//--------------------------------------------------------------------------
// 静的に初期化された ConditionVariableType オブジェクトを Win64 用に配置
// std::condition_variable_any 使用時の LazyInitialize 版はこちら。
//
#define NN_OS_CONDITION_VARIABLE_INITIALIZER()                              \
        {                                                                   \
            0, /* nn::os::ConditionVariableType::State_NotInitialized */    \
               0, 0, 0,             /* padding */                           \
                        1, 0, 0, 0, /* _needLazyInitialize = true */        \
            0, 0, 0, 0, 0, 0, 0, 0, /* _Cnd_t */                            \
            0, 0, 0, 0, 0, 0, 0, 0, /* _Mtx_t */                            \
        }

//--------------------------------------------------------------------------
#endif
#endif

#endif  // __cplusplus

