﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Device Tree に関する公開ヘッダファイル
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/os/os_InterruptEventCommon.h>

/**
 * @brief       Device Tree の phandle を表す型です。
 */
typedef uint32_t nndtPHandle;

/**
 * @brief       Device Tree のノード名の最大長です。
 * @details     Device Tree の仕様で決められている、ヌル終端を含めたノード名の最大長です。
 */
const size_t nndtMaxNodeNameLength = 32;

/**
 * @brief       Device Tree のプロパティ名の最大長です。
 * @details     Device Tree の仕様で決められている、ヌル終端を含めたプロパティ名の最大長です。
 */
const size_t nndtMaxPropertyNameLength = 32;

/**
 * @brief       Device Tree のノードを表す構造体です。
 * @details     Device Tree のノードを表す構造体です。
 *              dt ライブラリの API で用いるために定義されています。
 *              DDK ユーザーは、この構造体のデフォルトコンストラクタのメンバを使用しないでください。
 */
typedef struct nndtNode
{
    int32_t offset;
} nndtNode;

/**
 * @brief       割り込みが エッジトリガ / レベルトリガ のどちらなのかを示す列挙型です。
 */
typedef enum nndtInterruptTriggerType
{
    nndtInterruptTriggerType_Unspecified,   //!< エッジトリガ / レベルトリガのどちらなのか指定されていません
    nndtInterruptTriggerType_Edge,          //!< エッジトリガです
    nndtInterruptTriggerType_Level,         //!< レベルトリガです
} nndtInterruptTriggerType;

/**
 * @brief       レベルトリガの割り込みが active high / active low のどちらなのかを示す列挙型です。
 */
typedef enum nndtInterruptPolarityType
{
    nndtInterruptPolarityType_Unspecified,  //!< active high / active low のどちらなのか指定されていません
    nndtInterruptPolarityType_ActiveHigh,   //!< active high です
    nndtInterruptPolarityType_ActiveLow,    //!< active low です
} nndtInterruptPolarityType;

/**
 * @brief       割り込みに関する情報を表す構造体です。
 */
typedef struct nndtInterruptInfo
{
    nnosInterruptName name;             //!< 割込みイベントの名前が格納されます。
    nndtInterruptTriggerType trigger;   //!< エッジトリガ / レベルトリガ のどちらなのかの情報が格納されます。
    nndtInterruptPolarityType polarity; //!< active high / active low のどちらなのかの情報が格納されます。
} nndtInterruptInfo;
