﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * このファイルは直接編集しないで下さい。
 * このファイルは自動生成されます。
 * Don't edit this file directly.
 * This file is generated automatically.
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/nn_Result.h>

#include <nnc/dt/dt_Types.h>

// C Linkage
#ifndef NN_EXTERN_C
#ifdef  __cplusplus
#define NN_EXTERN_C extern "C"
#else
#define NN_EXTERN_C extern
#endif
#endif


/**
 * @brief 指定されたノードが扱う割り込みの数を取得します。
 * @details 詳細は ::nn::dt::GetInterruptCount() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetInterruptCount(int * pOutCount, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱う割り込みに関する情報を取得します。
 * @details 詳細は ::nn::dt::GetInterrupt() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetInterrupt(nndtInterruptInfo * pOutInfo, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱う割り込みに関する情報の配列を取得します。
 * @details 詳細は ::nn::dt::GetInterruptArray() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetInterruptArray(nndtInterruptInfo * pOutArray, int count, const nndtNode * pNode);

/**
 * @brief 指定されたノードが扱う割り込みに関する情報の配列を取得します。
 * @details 詳細は ::nn::dt::GetInterruptList() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetInterruptList(nndtInterruptInfo * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode);

/**
 * @brief 指定されたパスにあるノードを検索します。
 * @details 詳細は ::nn::dt::FindNodeByPath() を参照してください。
 */
NN_EXTERN_C nnResult nndtFindNodeByPath(nndtNode * pOutNode, const char * path);

/**
 * @brief 指定された phandle に対応するノードを検索します。
 * @details 詳細は ::nn::dt::FindNodeByPHandle() を参照してください。
 */
NN_EXTERN_C nnResult nndtFindNodeByPHandle(nndtNode * pOutNode, nndtPHandle phandle);

/**
 * @brief compatible なノードの数を取得します。
 * @details 詳細は ::nn::dt::GetCompatibleNodeCount() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetCompatibleNodeCount(int * pOutCount, const char * compatible);

/**
 * @brief compatible なノードのリストを取得します。
 * @details 詳細は ::nn::dt::ListCompatibleNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtListCompatibleNode(nndtNode * pOutNodeList, int * pOutCount, int maxCount, const char * compatible);

/**
 * @brief 親ノードを取得します。
 * @details 詳細は ::nn::dt::GetParentNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetParentNode(nndtNode * pOutNode, const nndtNode * pCurrentNode);

/**
 * @brief 指定した名前の子ノードを取得します。
 * @details 詳細は ::nn::dt::GetChildNodeByName() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetChildNodeByName(nndtNode * pOutNode, const nndtNode * pCurrentNode, const char * name);

/**
 * @brief 子ノードの数を取得します。
 * @details 詳細は ::nn::dt::GetChildNodeCount() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetChildNodeCount(int * pOutCount, const nndtNode * pCurrentNode);

/**
 * @brief 子ノードのリストを取得します。
 * @details 詳細は ::nn::dt::ListChildNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtListChildNode(nndtNode * pOutNodeList, int * pOutCount, int maxCount, const nndtNode * pCurrentNode);

/**
 * @brief 最初の子ノードを取得します。
 * @details 詳細は ::nn::dt::GetFirstChildNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetFirstChildNode(nndtNode * pOutNode, const nndtNode * pCurrentNode);

/**
 * @brief 次のノードを取得します。
 * @details 詳細は ::nn::dt::GetNextSiblingNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetNextSiblingNode(nndtNode * pOutNode, const nndtNode * pCurrentNode);

/**
 * @brief ノードの address-cells を取得します。
 * @details 詳細は ::nn::dt::GetValueOfAddressCells() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetValueOfAddressCells(uint32_t * pOutValue, const nndtNode * pNode);

/**
 * @brief ノードの size-cells を取得します。
 * @details 詳細は ::nn::dt::GetValueOfSizeCells() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetValueOfSizeCells(uint32_t * pOutValue, const nndtNode * pNode);

/**
 * @brief プロパティの有無を取得します。
 * @details 詳細は ::nn::dt::IsPropertyExist() を参照してください。
 */
NN_EXTERN_C nnResult nndtIsPropertyExist(bool * pOut, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティのサイズを取得します。
 * @details 詳細は ::nn::dt::GetPropertySize() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertySize(size_t * pOutSize, const nndtNode * pNode, const char * name);

/**
 * @brief プロパティに格納されている文字列または stringlist を取得します。
 * @details 詳細は ::nn::dt::GetPropertyString() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetPropertyString(size_t * pOutSize, char * pOutBuffer, size_t bufferSize, const nndtNode * pNode, const char * name);

/**
 * @brief ノードのパスを取得します。
 * @details 詳細は ::nn::dt::GetNodePath() を参照してください。
 */
NN_EXTERN_C nnResult nndtGetNodePath(char * pOutBuffer, size_t bufferSize, const nndtNode * pNode);

/**
 * @brief ノードの内容をログに出力します。
 * @details 詳細は ::nn::dt::DumpNode() を参照してください。
 */
NN_EXTERN_C nnResult nndtDumpNode(const nndtNode * pNode, int depth);

