﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#if  defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6)
    #include <nn/svc/bdsl-imx6/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::bdslimx6;
        }}
    #endif  // ifdef __cplusplus

#elif defined(NN_BUILD_CONFIG_HARDWARE_KZMA9)
    #include <nn/svc/kzm-a9/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::kzma9;
        }}
    #endif  // ifdef __cplusplus

#elif defined NN_BUILD_CONFIG_HARDWARE_SMMA53
    #include <nn/svc/smma53/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::smma53;
        }}
    #endif  // ifdef __cplusplus

#elif defined NN_BUILD_CONFIG_HARDWARE_JUNO
    #include <nn/svc/juno/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::juno;
        }}
    #endif  // ifdef __cplusplus

#elif defined NN_BUILD_CONFIG_SOC_TEGRA_X1
    #include <nn/svc/tegra-x1/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::tegrax1;
        }}
    #endif  // ifdef __cplusplus

#elif defined NN_BUILD_CONFIG_SOC_TEGRA_K1
    #include <nn/svc/tegra-k1/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::tegrak1;
        }}
    #endif  // ifdef __cplusplus

#elif defined NN_BUILD_CONFIG_SOC_TEGRA_X2
    #include <nn/svc/tegra-x2/svc_HardwareParams.h>
    #ifdef __cplusplus
        namespace nn { namespace svc {
            using namespace nn::svc::tegrax2;
        }}
    #endif  // ifdef __cplusplus

#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected
#endif

