﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace spl {

    const size_t KeySourceSize = 16;
    const size_t AesKeySize    = 16;
    const size_t AesBlockSize  = 16;

    const int LatestKeyGeneration =
#include "spl_KeyGeneration.inc"
    ;

    enum ConfigItem
    {
        ConfigItem_DisableDescVerification       = 1,
        ConfigItem_DramId                        = 2,
        ConfigItem_InterruptNumber               = 3,
        ConfigItem_FuseVersion                   = 4,
        ConfigItem_HardwareType                  = 5,
        ConfigItem_HardwareState                 = 6,
        ConfigItem_IsRecoveryBoot                = 7,
        ConfigItem_DeviceId                      = 8,
        ConfigItem_BootReason                    = 9,
        ConfigItem_MemoryMode                    = 10,
        ConfigItem_IsDevelopmentFunctionEnabled  = 11,
        ConfigItem_KernelFlags                   = 12,
        ConfigItem_IsChargerHiZModeEnabled       = 13,
        ConfigItem_RetailInteractiveDisplayState = 14,
        ConfigItem_Regulator                     = 15,
        ConfigItem_DeviceUniqueKeyGeneration     = 16,
        ConfigItem_Package2Hash                  = 17,
    };

    enum HardwareType
    {
        HardwareType_Icosa,
        HardwareType_Copper,
        HardwareType_Hoag,
        HardwareType_Iowa,
    };

    enum SocType
    {
        SocType_Erista,
        SocType_Mariko,
    };

    enum HardwareState
    {
        HardwareState_Development,
        HardwareState_End,
    };

    enum DramId
    {
        DramId_IcosaSamsung2g      = 0,
        DramId_IcosaHynix          = 1,
        DramId_IcosaMicron         = 2,
        DramId_CopperSamsung2g     = 3,
        DramId_IcosaSamsung3g      = 4,
        DramId_CopperHynix         = 5,
        DramId_CopperMicron        = 6,
        DramId_IowaSamsung2g       = 7,
        DramId_IowaX3Samsung2g     = 8,
        DramId_IowaX3Samsung4g     = 9,
        DramId_IowaX3Hynix         = 10,
        DramId_IowaX3Micron        = 11,
        DramId_HoagSamsung2g       = 12,
        DramId_HoagSamsung4g       = 13,
        DramId_HoagHynix           = 14,
        DramId_HoagMicron          = 15,
    };

    enum RetailInteractiveDisplayState
    {
        RetailInteractiveDisplayState_Disabled,
        RetailInteractiveDisplayState_Enabled,
    };

    enum Regulator
    {
        Regulator_Max77621,
        Regulator_Max77812PhaseConfiguration31,
        Regulator_Max77812PhaseConfiguration211,
    };

    enum KeyPurpose
    {
        KeyPurpose_CalibrationDataAreaEncryption0 = 0,
        KeyPurpose_CalibrationDataAreaEncryption1 = 1
    };

    enum BootReason
    {
        BootReason_Unknown,
        BootReason_AcOk,
        BootReason_OnKey,
        BootReason_RtcAlarm1,
        BootReason_RtcAlarm2,
    };

    struct AccessKey
    {
        Bit8    value[16];
    };

    struct BootReasonValue
    {
        Bit8    onOffIrq;
        Bit8    rtcInt;
        Bit8    nverc;
        Bit8    bootReason;     // BootReason
    };
    NN_STATIC_ASSERT( sizeof(BootReasonValue) == sizeof(Bit32) );

}}  // namespace nn::spl

