﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include <nn/spl/spl_Types.h>

namespace nn { namespace spl { namespace smc {

    enum SmcResult
    {
        SmcResult_Success               = 0,
        SmcResult_NotSupported          = 1,
        SmcResult_InvalidArgument       = 2,
        SmcResult_Busy                  = 3,
        SmcResult_NoAsyncOperation      = 4,
        SmcResult_InvalidAsyncKey       = 5,

        SmcResult_PsciSuccess           = static_cast<Bit32>( 0),
        SmcResult_PsciNotSupported      = static_cast<Bit32>(-1),
        SmcResult_PsciInvalidParameters = static_cast<Bit32>(-2),
        SmcResult_PsciDenied            = static_cast<Bit32>(-3),
        SmcResult_PsciAlreadyOn         = static_cast<Bit32>(-4),
    };

    enum CipherMode
    {
        CipherMode_CbcEncryption,
        CipherMode_CbcDecryption,
        CipherMode_Ctr,
        CipherMode_Cmac,
    };

    enum EsDeviceUniqueKeyType
    {
        EsDeviceUniqueKeyType_TitleKey,
        EsDeviceUniqueKeyType_ArchiveKey,
    };

    struct AccessKey
    {
        Bit64 value[2];
    };

    struct OperationKey
    {
        Bit64 value;
    };

    struct GcKey
    {
        Bit64 value;
    };

}}}  // namespace nn::spl::smc

