﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/detail/spl_InternalTypes.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace spl { namespace detail { // NOLINT(whitespace/braces)

class IDeviceUniqueDataInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDeviceUniqueDataInterface, (::nn::spl::detail::ICryptoInterface))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDeviceUniqueDataInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecryptDeviceUniqueData, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDeviceUniqueDataInterface)

        ::nn::Result DecryptDeviceUniqueData(const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecryptDeviceUniqueData, (result, data, accessKey, keySource));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDeviceUniqueDataInterface : public ::nn::spl::detail::ICryptoInterface
    {
    public:
        nn::Result DecryptDeviceUniqueData(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
    nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
    nn::Result DecryptDeviceUniqueData(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT;
    nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT;
    nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT;
    nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT;
    nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
    nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::spl::detail::IDeviceUniqueDataInterface), (::nn::spl::detail::ICryptoInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptDeviceUniqueData, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecryptDeviceUniqueData, (result, data, accessKey, keySource));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::spl::detail::IDeviceUniqueDataInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::spl::detail::IDeviceUniqueDataInterface), (::nn::spl::detail::ICryptoInterface))

    // nn::Result DecryptDeviceUniqueData(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecryptDeviceUniqueData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (result, data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, keySource))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecryptDeviceUniqueData)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::AccessKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::KeySource), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::AesKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::IvIc), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::Cmac), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::BootReasonValue), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::spl::detail::IDeviceUniqueDataInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::spl::detail::IDeviceUniqueDataInterface), (::nn::spl::detail::ICryptoInterface))

    // nn::Result DecryptDeviceUniqueData(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptDeviceUniqueData, (const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecryptDeviceUniqueData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecryptDeviceUniqueData)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::spl::detail::IDeviceUniqueDataInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::spl::detail::IDeviceUniqueDataInterface), (::nn::spl::detail::ICryptoInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecryptDeviceUniqueData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecryptDeviceUniqueData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecryptDeviceUniqueData)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::spl::detail::IDeviceUniqueDataInterface))
