﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/detail/spl_InternalTypes.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace spl { namespace detail { // NOLINT(whitespace/braces)

class ICryptoInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ICryptoInterface, (::nn::spl::detail::IGeneralInterface))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ICryptoInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKek, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCtr, (const ::nn::sf::OutBuffer& outBuffer, ::std::int32_t slotIndex, const ::nn::sf::InBuffer& inBuffer, const ::nn::spl::detail::IvIc& initialCounter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCmac, (::nn::sf::Out<::nn::spl::detail::Cmac> pOut, ::std::int32_t slotIndex, const ::nn::sf::InArray<::nn::Bit8>& data))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AllocateAesKeySlot, (::nn::sf::Out<::std::int32_t> slotIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeallocateAesKeySlot, (::std::int32_t slotIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAesKeySlotAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ICryptoInterface)

        ::nn::Result GenerateAesKek(::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateAesKek, (accessKey, keySource, generation, option));
        }

        ::nn::Result LoadAesKey(::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAesKey, (slotIndex, accessKey, keySource));
        }

        ::nn::Result GenerateAesKey(::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateAesKey, (key, accessKey, keySource));
        }

        ::nn::Result DecryptAesKey(::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecryptAesKey, (key, keySource, generation, option));
        }

        ::nn::Result ComputeCtr(const ::nn::sf::OutBuffer& outBuffer, ::std::int32_t slotIndex, const ::nn::sf::InBuffer& inBuffer, const ::nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ComputeCtr, (outBuffer, slotIndex, inBuffer, initialCounter));
        }

        ::nn::Result ComputeCmac(::nn::sf::Out<::nn::spl::detail::Cmac> pOut, ::std::int32_t slotIndex, const ::nn::sf::InArray<::nn::Bit8>& data) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ComputeCmac, (pOut, slotIndex, data));
        }

        ::nn::Result AllocateAesKeySlot(::nn::sf::Out<::std::int32_t> slotIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AllocateAesKeySlot, (slotIndex));
        }

        ::nn::Result DeallocateAesKeySlot(::std::int32_t slotIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeallocateAesKeySlot, (slotIndex));
        }

        ::nn::Result GetAesKeySlotAvailableEvent(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAesKeySlotAvailableEvent, (handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ICryptoInterface : public ::nn::spl::detail::IGeneralInterface
    {
    public:
        nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
        nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
        nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
        nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
        nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT;
        nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT;
        nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT;
        nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT;
        nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
    nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
    nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT;
    nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT;
    nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT;
    nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT;
    nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
    nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::spl::detail::ICryptoInterface), (::nn::spl::detail::IGeneralInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKek, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateAesKek, (accessKey, keySource, generation, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAesKey, (slotIndex, accessKey, keySource));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateAesKey, (key, accessKey, keySource));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecryptAesKey, (key, keySource, generation, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCtr, (const ::nn::sf::OutBuffer& outBuffer, ::std::int32_t slotIndex, const ::nn::sf::InBuffer& inBuffer, const ::nn::spl::detail::IvIc& initialCounter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ComputeCtr, (outBuffer, slotIndex, inBuffer, initialCounter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCmac, (::nn::sf::Out<::nn::spl::detail::Cmac> pOut, ::std::int32_t slotIndex, const ::nn::sf::InArray<::nn::Bit8>& data))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ComputeCmac, (pOut, slotIndex, data));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AllocateAesKeySlot, (::nn::sf::Out<::std::int32_t> slotIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AllocateAesKeySlot, (slotIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeallocateAesKeySlot, (::std::int32_t slotIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeallocateAesKeySlot, (slotIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAesKeySlotAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAesKeySlotAvailableEvent, (handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::spl::detail::ICryptoInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::spl::detail::ICryptoInterface), (::nn::spl::detail::IGeneralInterface))

    // nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateAesKek)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::Bit32), 20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (keySource, generation, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (accessKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateAesKek)

    // nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (accessKey, keySource, slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAesKey)

    // nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, keySource))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(key, (::nn::spl::detail::AesKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateAesKey)

    // nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecryptAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::Bit32), 20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (keySource, generation, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(key, (::nn::spl::detail::AesKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecryptAesKey)

    // nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ComputeCtr)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(initialCounter, (::nn::spl::detail::IvIc), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (initialCounter, slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(initialCounter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ComputeCtr)

    // nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ComputeCmac)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::spl::detail::Cmac), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ComputeCmac)

    // nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AllocateAesKeySlot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AllocateAesKeySlot)

    // nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeallocateAesKeySlot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeallocateAesKeySlot)

    // nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAesKeySlotAvailableEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAesKeySlotAvailableEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::AccessKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::KeySource), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::AesKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::IvIc), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::Cmac), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::BootReasonValue), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::spl::detail::ICryptoInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::spl::detail::ICryptoInterface), (::nn::spl::detail::IGeneralInterface))

    // nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKek, (::nn::sf::Out<::nn::spl::AccessKey> accessKey, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateAesKek)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateAesKek)
    }

    // nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAesKey)
    }

    // nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateAesKey)
    }

    // nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecryptAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecryptAesKey)
    }

    // nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCtr, (const ::nn::sf::OutBuffer& outBuffer, ::std::int32_t slotIndex, const ::nn::sf::InBuffer& inBuffer, const ::nn::spl::detail::IvIc& initialCounter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ComputeCtr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(initialCounter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ComputeCtr)
    }

    // nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ComputeCmac, (::nn::sf::Out<::nn::spl::detail::Cmac> pOut, ::std::int32_t slotIndex, const ::nn::sf::InArray<::nn::Bit8>& data))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ComputeCmac)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ComputeCmac)
    }

    // nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AllocateAesKeySlot, (::nn::sf::Out<::std::int32_t> slotIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AllocateAesKeySlot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AllocateAesKeySlot)
    }

    // nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeallocateAesKeySlot, (::std::int32_t slotIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeallocateAesKeySlot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeallocateAesKeySlot)
    }

    // nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAesKeySlotAvailableEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAesKeySlotAvailableEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAesKeySlotAvailableEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::spl::detail::ICryptoInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::spl::detail::ICryptoInterface), (::nn::spl::detail::IGeneralInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateAesKek)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateAesKek)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecryptAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecryptAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ComputeCtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ComputeCtr)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(initialCounter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ComputeCmac)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ComputeCmac)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AllocateAesKeySlot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AllocateAesKeySlot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(slotIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeallocateAesKeySlot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeallocateAesKeySlot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAesKeySlotAvailableEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAesKeySlotAvailableEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateAesKek)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecryptAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ComputeCtr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ComputeCmac)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AllocateAesKeySlot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeallocateAesKeySlot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAesKeySlotAvailableEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::spl::detail::ICryptoInterface))
