﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace socket {

/*
* Ioctl's have the command encoded in the lower word, and the size of
* any in or out parameters in the upper word.  The high 3 bits of the
* upper word are used to encode the in/out status of the parameter.
*/
#define NN_SOCKET_IOCPARM_SHIFT   13                              // NOLINT(readability/define)
#define NN_SOCKET_IOCPARM_MASK    ((1 << NN_SOCKET_IOCPARM_SHIFT) - 1)
#define NN_SOCKET_IOCPARM_LEN(x)  (((x) >> 16) & NN_SOCKET_IOCPARM_MASK)
#define NN_SOCKET_IOCBASECMD(x)  ((x) & ~(NN_SOCKET_IOCPARM_MASK << 16))
#define NN_SOCKET_IOCGROUP(x)    (((x) >> 8) & 0xff)
#define NN_SOCKET_IOCPARM_MAX     (1 << NN_SOCKET_IOCPARM_SHIFT)
#define NN_SOCKET_IOC_VOID        0x20000000                      // NOLINT(readability/define)
#define NN_SOCKET_IOC_OUT         0x40000000                      // NOLINT(readability/define)
#define NN_SOCKET_IOC_IN          0x80000000                      // NOLINT(readability/define)
#define NN_SOCKET_IOC_INOUT       (NN_SOCKET_IOC_IN | NN_SOCKET_IOC_OUT)
#define NN_SOCKET_IOC_DIRMASK     (NN_SOCKET_IOC_VOID | NN_SOCKET_IOC_OUT | NN_SOCKET_IOC_IN)   // NOLINT(readability/define)

#define NN_SOCKET_IOC(inout,group,num,len) \
    ((unsigned long)((inout) | (((len) & NN_SOCKET_IOCPARM_MASK) << 16) | ((group) << 8) | (num)))

#define NN_SOCKET_IO(g,n)         NN_SOCKET_IOC(NN_SOCKET_IOC_VOID,  (g), (n), 0)
#define NN_SOCKET_IOWINT(g,n)     NN_SOCKET_IOC(NN_SOCKET_IOC_VOID,  (g), (n), sizeof(int))
#define NN_SOCKET_IOR(g,n,t)      NN_SOCKET_IOC(NN_SOCKET_IOC_OUT,   (g), (n), sizeof(t))
#define NN_SOCKET_IOW(g,n,t)      NN_SOCKET_IOC(NN_SOCKET_IOC_IN,    (g), (n), sizeof(t))
#define NN_SOCKET_IOWR(g,n,t)     NN_SOCKET_IOC(NN_SOCKET_IOC_INOUT, (g), (n), sizeof(t))

}} /* nn::socket */
