﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace socket {

/*
 * UDP protocol header.
 * Per RFC 768, September, 1981.
 */
struct UdpHdr
{
    uint16_t    uh_sport;                   /* source port */
    uint16_t    uh_dport;                   /* destination port */
    uint16_t    uh_ulen;                    /* udp length */
    uint16_t    uh_sum;                     /* udp checksum */
};

/*
 * UDP Encapsulation of IPsec Packets options.
 */
/* Encapsulation types. */
enum class UdpEncap : uint16_t
{
    Udp_Encap_EspInUdp_Non_Ike      = 1,    /* draft-ietf-ipsec-nat-t-ike-00/01 */
    Udp_Encap_EspInUdp              = 2,    /* draft-ietf-ipsec-udp-encaps-02+ */
    Udp_Encap_EspInUdp_Port         = 500,
    Udp_Encap_EspInUdp_MaxFragLen   = 552
};

}} /* nn::socket */
