﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>

namespace nn {
namespace sm {

    namespace detail
    {
        const char PortNameForManager[] = "sm:m";
    }

    Result InitializeForManager() NN_NOEXCEPT;
    Result FinalizeForManager() NN_NOEXCEPT;

    Result RegisterProcess(os::ProcessId id,
        const void* pAccessRightsLimit, size_t limitSize,
        const void* pAccessRights,      size_t rightsSize ) NN_NOEXCEPT;
    Result UnregisterProcess(os::ProcessId id) NN_NOEXCEPT;

} // end of namespace sm
} // end of namespace nn
