﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

// 上位ユーザ用 API ヘッダ

namespace nn { namespace sfsmpl {

// ライブラリ初期化処理
// このサンプルでは DFC の場合と HIPC の場合とで別シンボルにしているが、
// 同一シンボルとして、内部で実装を分岐してもよい。
void InitializeCalculatorByDfc() NN_NOEXCEPT;
void InitializeCalculatorByHipc() NN_NOEXCEPT;

// ライブラリ終了処理
void FinalizeCalculator() NN_NOEXCEPT;

// Calculator 機能
int32_t Negate(int32_t x) NN_NOEXCEPT;
int32_t Add(int32_t x, int32_t y) NN_NOEXCEPT;
int32_t Sub(int32_t x, int32_t y) NN_NOEXCEPT;

}}
