﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <atomic>

#include <nn/nn_SdkAssert.h>

namespace nn { namespace sf { namespace impl { namespace detail {

class ServiceObjectImplBase2
{
private:

    typedef uint32_t InnerInt;
    std::atomic<InnerInt> m_RefCount;

protected:

    ServiceObjectImplBase2() NN_NOEXCEPT
        : m_RefCount(1)
    {
    }

    void AddReferenceImpl() NN_NOEXCEPT;

    bool ReleaseImpl() NN_NOEXCEPT;

};

}}}}
