﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/detail/sf_CommonUtil.h>

namespace nn { namespace sf { namespace impl { namespace detail {

template <typename Interface, typename Base, typename ImplHolder, typename ImplGetter, typename RootInterface>
class ImplTemplateBaseT;

// "実装テンプレート"実装用ベースクラステンプレート
//
// Base と ImplHolder を継承し、Interface の実装クラスを生成する。
// ImplGetter::GetImplPointer(ImplHolder*) で返されるポインタ p は、Interface の各メソッドを実装している必要がある。
// なお、寿命管理 AddReference/Release は実装していないため、別途実装が必要である。
// このテンプレートは、NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE マクロ群から、
// Interface 部の部分特殊化が行われる。
template <typename Interface_, typename Base, typename ImplHolder, typename ImplGetter>
class ImplTemplateBase
    : public ImplTemplateBaseT<Interface_, Base, ImplHolder, ImplGetter, Interface_>
{
private:
    typedef ImplTemplateBaseT<Interface_, Base, ImplHolder, ImplGetter, Interface_> BaseBase;
public:
    using BaseBase::BaseBase;
};

}}}}
