﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/hipc/server/sf_HipcServerSessionManager.h>
#include <nn/sf/cmif/server/sf_CmifServerDomainManager.h>

namespace nn { namespace sf { namespace hipc { namespace server {

class HipcServerSessionManagerWithDomain
    : public HipcServerSessionManager
    , private cmif::server::CmifServerDomainManager
{
private:

    virtual Result ProcessManagerInvoke(HipcServerSession* pSession, const hipc::detail::HipcMessageBufferAccessor* pInAccessor, const hipc::detail::HipcMessageHeaderInfo* pInRequestHeaderInfo, void* outMessageBuffer, size_t outMessageBufferSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Process2ManagerInvoke(HipcServerSession* pSession, void* inMessageBuffer, size_t inMessageBufferSize, void* outMessageBuffer, size_t outMessageBufferSize) NN_NOEXCEPT NN_OVERRIDE;

    class HipcManagerImpl;

public:

    typedef cmif::server::CmifServerDomainManager::DomainStorage DomainStorage;
    typedef cmif::server::CmifServerDomainManager::EntryStorage DomainEntryStorage;

    HipcServerSessionManagerWithDomain(EntryStorage entryBuffer[], int entryCount) NN_NOEXCEPT
        : cmif::server::CmifServerDomainManager(entryBuffer, entryCount)
    {
    }

};

}}}}
