﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// インターフェイス生成のために、自動生成系が使用するヘッダ・マクロ群
// マクロは NN_SF_DETAIL_ 以下であり、フレームワーク実装外からの使用は不可

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/detail/sf_CommonUtil.h>
#include <type_traits>
#include <memory>

namespace nn { namespace sf { namespace cmif { namespace server { namespace detail {
    template <typename Interface>
    struct CmifProcessFunctionTableGetterImpl;
}}}}}

#define NN_SF_DETAIL_SYNC_METHOD_NAME(name) _nn_sf_sync_##name

#define NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(name, baseType) \
    class name : public NN_SF_DETAIL_STRIP_PAREN(baseType) \
    { \
        friend struct ::nn::sf::cmif::server::detail::CmifProcessFunctionTableGetterImpl<name>; \
    protected: \
        ~name() NN_NOEXCEPT \
        { \
        }

    #define NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(name) \
        private:
        // TODO:
        //   一時措置として public にしている。
        //   public のままだと、インテリセンスを汚すため、
        //   private: とし、friend なアクセッサオブジェクトを別途作成するべき。

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, args) \
            virtual ::nn::Result NN_SF_DETAIL_SYNC_METHOD_NAME(name) args NN_NOEXCEPT = 0;

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(name) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, ())

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(name, args) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, args)

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(name) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, ())

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(name, args) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, args)

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(name, type) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, (::nn::sf::Out<NN_SF_DETAIL_STRIP_PAREN(type)>))

        #define NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(name, type, args) \
            NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_IMPL(name, (::nn::sf::Out<NN_SF_DETAIL_STRIP_PAREN(type)>, NN_SF_DETAIL_STRIP_PAREN(args)))

    #define NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    #define NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(name) \
        public:

        #define NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE(c, message) \
            NN_SDK_ASSERT(::nn::sf::detail::ToPreConditionBool(c), "pre-condition faliure: " message);

        #define NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD(name, args) \
            this->NN_SF_DETAIL_SYNC_METHOD_NAME(name) args

        #define NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD_VOID(name, args) \
            static_cast<void>(static_cast<::nn::ResultSuccess>(NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD(name, args)))

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(name) \
            return NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD(name, ())

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(name, args) \
            return NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD(name, args)

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(name) \
            return NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD_VOID(name, ())

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(name, args) \
            return NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD_VOID(name, args)

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(name, type) \
            NN_SF_DETAIL_STRIP_PAREN(type) _out; \
            NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD_VOID(name, (::std::addressof(_out))); \
            return _out

        #define NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(name, type, args) \
            NN_SF_DETAIL_STRIP_PAREN(type) _out; \
            NN_SF_DETAIL_CALL_INTERNAL_SYNC_METHOD_VOID(name, (::std::addressof(_out), NN_SF_DETAIL_STRIP_PAREN(args))); \
            return _out

    #define NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

#define NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END \
    };
