﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// インターフェイス生成のために、自動生成系が使用するヘッダ・マクロ群
// マクロは NN_SF_CMIF_DETAIL_ 以下であり、フレームワーク実装外からの使用は不可

#include <nn/nn_Macro.h>
#include <nn/sf/cmif/detail/sf_CmifMethodInfos.h>

#include <nn/sf/cmif/sf_CmifMessageCommon.h>
#include <nn/sf/detail/sf_CommonUtil.h>
#include <cstddef>
#include <tuple>

// インターフェイスメソッドに関する情報を集めた struct MethodInfos を作成するための
// 自動生成系用マクロ群。
// 自動生成系は、このクラステンプレートを明示的特殊化する。
// インターフェイス Interface のメソッド名 Method のメタ情報を
// nn::sf::cmif::detail::MethodInfos<Interface>::Method を使用して得ることができる。
// サーバ用やクライアント用の自動生成系コードから使用される。

#define NN_SF_CMIF_METHOD_INFO_NAMESPACE ::nn::sf::cmif::detail

#define NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) _argument_info_##name

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BASE(type) \
    namespace nn { namespace sf { namespace cmif { namespace detail { \
    \
    /* インテリセンスでのエラー防止のためにプライマリテンプレートを再度宣言 */ \
    template <typename Interface> \
    struct MethodInfos; \
    \
    template <> \
    struct MethodInfos<NN_SF_DETAIL_STRIP_PAREN(type)> \

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_INHERIT(baseType) \
        : public ::nn::sf::cmif::detail::MethodInfos<NN_SF_DETAIL_STRIP_PAREN(baseType)>

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BEGIN \
    {

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS(type) \
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BASE(type) \
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BEGIN

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE(type, base) \
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BASE(type) \
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_INHERIT(base) \
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_BEGIN

    #define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(name) \
    private: \
        struct _impl_##name : public ::nn::sf::cmif::detail::MethodInfoBase \
        {

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(id) static const ::nn::sf::cmif::MethodId MethodId = (id);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE() static const bool InProcessIdEnable = true;
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(size) static const ::std::size_t InRawSize = (size);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(size) static const ::std::size_t OutRawSize = (size);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_BUFFER_COUNT(count) static const int InBufferCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_BUFFER_COUNT(count) static const int OutBufferCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(count) static const int BufferCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_OBJECT_COUNT(count) static const int InObjectCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(count) static const int OutObjectCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(count) static const int InNativeHandleCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_MOVE_IN_NATIVE_HANDLE_COUNT(count) static const int MoveInNativeHandleCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(count) static const int OutNativeHandleCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_MOVE_OUT_NATIVE_HANDLE_COUNT(count) static const int MoveOutNativeHandleCount = (count);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(b) static const bool ReturnTypeIsVoid = (b);
        #define NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(b) static const bool ReturnTypeIsResult = (b);

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT \
            struct InRawStruct \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, t, offset) \
                ::nn::sf::detail::TypeIdentity<NN_SF_DETAIL_STRIP_PAREN(t)>::type name; \
                typedef ::nn::sf::detail::TypeIdentity<NN_SF_DETAIL_STRIP_PAREN(t)>::type _type_##name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::InRawArgumentInfo<sizeof(_type_##name), NN_ALIGNOF(_type_##name), offset>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(count, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT \
            struct OutRawStruct \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(name, t, offset) \
                ::nn::sf::detail::TypeIdentity<NN_SF_DETAIL_STRIP_PAREN(t)>::type name; \
                typedef ::nn::sf::detail::TypeIdentity<NN_SF_DETAIL_STRIP_PAREN(t)>::type _type_##name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::OutRawArgumentInfo<sizeof(_type_##name), NN_ALIGNOF(_type_##name), offset>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(count, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS \
            struct BufferInfos \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, index, t, attribute) \
                typedef ::nn::sf::cmif::detail::BufferInfoBase<index, NN_SF_DETAIL_STRIP_PAREN(t), attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::BufferArgumentInfo<index, attribute>;

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(name, index, t, size, attribute) \
                typedef ::nn::sf::cmif::detail::BufferInfoBase<index, NN_SF_DETAIL_STRIP_PAREN(t), ::nn::sf::cmif::BufferAttribute_FixedSize | attribute, size> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::BufferArgumentInfo<index, ::nn::sf::cmif::BufferAttribute_FixedSize | attribute, size>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(count, args) \
                NN_SF_DETAIL_DEFINE_TYPE_LIST(_typelist, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS \
            struct InNativeHandleInfos \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(name, index, attribute) \
                typedef ::nn::sf::cmif::detail::NativeHandleInfoBase<index, attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::InHandleArgumentInfo<index, attribute>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(count, args) \
                NN_SF_DETAIL_DEFINE_TYPE_LIST(_typelist, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS \
            struct OutNativeHandleInfos \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(name, index, attribute) \
                typedef ::nn::sf::cmif::detail::NativeHandleInfoBase<index, attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::OutHandleArgumentInfo<index, attribute>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(count, args) \
                NN_SF_DETAIL_DEFINE_TYPE_LIST(_typelist, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_OBJECT_INFOS \
            struct InObjectInfos \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_OBJECT_INFO(name, index, attribute) \
                typedef ::nn::sf::cmif::detail::ObjectInfoBase<index, attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::InObjectArgumentInfo<index, attribute>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_IN_OBJECT_INFOS_END(count, args) \
                NN_SF_DETAIL_DEFINE_TYPE_LIST(_typelist, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS \
            struct OutObjectInfos \
            {

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(name, index, attribute) \
                typedef ::nn::sf::cmif::detail::ObjectInfoBase<index, attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::OutObjectArgumentInfo<index, attribute>;

            #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO_EX(name, index, attribute, t) \
                typedef ::nn::sf::cmif::detail::ObjectInfoBase<index, attribute> name; \
                using NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name) = NN_SF_CMIF_METHOD_INFO_NAMESPACE::OutObjectArgumentInfo<index, attribute>;

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(count, args) \
                NN_SF_DETAIL_DEFINE_TYPE_LIST(_typelist, args) \
            };

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK(t, size, alignment) \
            static_assert(sizeof(NN_SF_DETAIL_STRIP_PAREN(t)) == size, "[SF-ST-LayoutMismatched:Size] sizeof" #t " != expected (= " #size ")"); \
            static_assert(alignment % NN_ALIGNOF(NN_SF_DETAIL_STRIP_PAREN(t)) == 0, "[SF-ST-LayoutMismatched:Alignment] expected (= " #alignment ") % alignof" #t " != 0");

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name) \
            AllArgumentInfos:: NN_SF_CMIF_DETAIL_ARGUMENT_INFO_NAME(name)

        #define NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(args) \
            struct AllArgumentInfos \
                : public InRawStruct \
                , public OutRawStruct \
                , public BufferInfos \
                , public InNativeHandleInfos \
                , public OutNativeHandleInfos \
                , public InObjectInfos \
                , public OutObjectInfos \
            { \
            }; \
            using ArgumentInfos = ::std::tuple<NN_SF_DETAIL_STRIP_PAREN(args)>;

    #define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(name) \
        }; \
    public: \
        typedef ::nn::sf::cmif::detail::MethodInfo<_impl_##name> name;

#define NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END \
    }; \
    \
    }}}}
