﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <type_traits>
#include <nn/sf/detail/sf_CmifProxyInfo.h>

namespace nn { namespace sf { namespace cmif { namespace client {

class CmifBaseObject;

template <typename Interface, typename ProxyKind, typename AllocationPolicy>
class CmifProxyFactory;

}}}}

namespace nn { namespace sf { namespace cmif { namespace client { namespace detail {

template <typename Interface, typename ProxyKind, typename AllocationPolicy, typename RootInterface>
class CmifProxyImpl;

// 自動生成系は、このクラステンプレートの Interface に関して部分特殊化する。
// (生成のためのマクロ群は <nn/sf/cmif/client/detail/sf_CmifClientAutogenProxyIncludes.h>)
// インターフェイス Interface 用のプロキシクライアント実装を、
// nn::sf::cmif::client::detail::CmifProxy<Interface, ProxyKind, AllocationPolicy> で得ることができる。
//
// このクラス自体の直接のインスタンス化はできないが、
// nn::sf::cmif::client::CmifProxyFactory<Interface, ProxyKind, AllocationPolicy> を使用することで、
// インスタンスを得ることができる。
// テンプレートパラメータ ProxyKind, AllocationPolicy に関しては、
// nn::sf::cmif::client::CmifProxyFactory を参照。
template <typename Interface, typename ProxyKind, typename AllocationPolicy, typename = void>
class CmifProxy
    : public CmifProxyImpl<Interface, ProxyKind, AllocationPolicy, Interface>
{
public:

    explicit CmifProxy(const typename ProxyKind::ObjectInfo& info) NN_NOEXCEPT
        : CmifProxyImpl<Interface, ProxyKind, AllocationPolicy, Interface>(info)
    {
    }

    CmifProxy() NN_NOEXCEPT
    {
    }

};

template <typename Interface, typename ProxyKind, typename AllocationPolicy>
class CmifProxy<Interface, ProxyKind, AllocationPolicy, typename std::enable_if<Interface::IsCallable == false>::type>
    : public Interface
    , public ProxyKind::ProxyBaseObject
{
private:

    typedef typename ProxyKind::ProxyBaseObject ProxyBase;

public:

    explicit CmifProxy(const typename ProxyBase::ObjectInfo& info) NN_NOEXCEPT
        : ProxyBase(info)
    {
    }

    CmifProxy() NN_NOEXCEPT
    {
    }

};

}}}}}
