﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sdmmc/sdmmc_Common.h>

namespace nn { namespace sdmmc {

    enum MmcPartition {
        MmcPartition_UserData,
        MmcPartition_BootPartition1,
        MmcPartition_BootPartition2,
        MmcPartition_Unknown
    };

    const size_t MmcExtendedCsdSize = 512;
    const size_t MmcWorkBufferSize = MmcExtendedCsdSize;

    void SetMmcWorkBuffer(Port port, void* pMmcWorkBuffer, size_t mmcWorkBufferSize) NN_NOEXCEPT;
    void PutMmcToSleep(Port port) NN_NOEXCEPT;
    void AwakenMmc(Port port) NN_NOEXCEPT;
    Result SelectMmcPartition(Port port, MmcPartition mmcPartition) NN_NOEXCEPT;
    Result EraseMmc(Port port) NN_NOEXCEPT;
    Result GetMmcBootPartitionCapacity(uint32_t* pOutNumSectors, Port port) NN_NOEXCEPT;
    Result GetMmcExtendedCsd(void* pOutExtendedCsdBuffer, size_t extendedCsdBufferSize, Port port) NN_NOEXCEPT;

}} // namespace nn { namespace sdmmc {
