﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sdmmc/sdmmc_Common.h>

namespace nn { namespace sdmmc {

    const size_t GcAsicOperationSize = 64;

    void PutGcAsicToSleep(Port port) NN_NOEXCEPT;
    Result AwakenGcAsic(Port port) NN_NOEXCEPT;
    Result WriteGcAsicOperation(Port port, const void* pOperationBuffer, size_t operationBufferSize) NN_NOEXCEPT;
    Result FinishGcAsicOperation(Port port) NN_NOEXCEPT;
    Result AbortGcAsicOperation(Port port) NN_NOEXCEPT;
    Result SleepGcAsic(Port port) NN_NOEXCEPT;
    Result UpdateGcAsicKey(Port port) NN_NOEXCEPT;
    void SignalGcRemovedEvent(Port port) NN_NOEXCEPT;
    void ClearGcRemovedEvent(Port port) NN_NOEXCEPT;

}} // namespace nn { namespace sdmmc {
