﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sdmmc/sdmmc_Common.h>
#include <nn/dd.h>

namespace nn { namespace sdmmc {

    const size_t BufferDeviceVirtualAddressAlignment = 8;   // 64 bit

    void RegisterDeviceVirtualAddress(Port port, uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT;
    void UnregisterDeviceVirtualAddress(Port port, uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT;

}} // namespace nn { namespace sdmmc {
