﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      ro モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_RO_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ro, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_RO_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_RO_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_RO_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_RO_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ro, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_RO_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_RO_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_RO_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_RO_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ro, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_RO_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_RO_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_RO_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ro, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_RO_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ro, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_RO_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_RO_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_RO_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_RO_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ro, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_RO_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_RO_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_RO_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ro, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_RO_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Trace, 0, format, args)
#define NN_DETAIL_RO_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Trace, 1, format, args)
#define NN_DETAIL_RO_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Trace, 2, format, args)
#define NN_DETAIL_RO_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Trace, 3, format, args)

#define NN_DETAIL_RO_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Info, 0, format, args)
#define NN_DETAIL_RO_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Info, 1, format, args)
#define NN_DETAIL_RO_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Info, 2, format, args)
#define NN_DETAIL_RO_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Info, 3, format, args)

#define NN_DETAIL_RO_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Warn, 0, format, args)
#define NN_DETAIL_RO_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Warn, 1, format, args)
#define NN_DETAIL_RO_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Warn, 2, format, args)
#define NN_DETAIL_RO_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Warn, 3, format, args)

#define NN_DETAIL_RO_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Error, 0, format, args)
#define NN_DETAIL_RO_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Error, 1, format, args)
#define NN_DETAIL_RO_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Error, 2, format, args)
#define NN_DETAIL_RO_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Error, 3, format, args)

#define NN_DETAIL_RO_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Fatal, 0, format, args)
#define NN_DETAIL_RO_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Fatal, 1, format, args)
#define NN_DETAIL_RO_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Fatal, 2, format, args)
#define NN_DETAIL_RO_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ro, Fatal, 3, format, args)

#define NN_DETAIL_RO_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ro, Trace, 0, text, length)
#define NN_DETAIL_RO_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Trace, 1, text, length)
#define NN_DETAIL_RO_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Trace, 2, text, length)
#define NN_DETAIL_RO_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Trace, 3, text, length)

#define NN_DETAIL_RO_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ro, Info, 0, text, length)
#define NN_DETAIL_RO_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Info, 1, text, length)
#define NN_DETAIL_RO_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Info, 2, text, length)
#define NN_DETAIL_RO_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Info, 3, text, length)

#define NN_DETAIL_RO_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ro, Warn, 0, text, length)
#define NN_DETAIL_RO_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Warn, 1, text, length)
#define NN_DETAIL_RO_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Warn, 2, text, length)
#define NN_DETAIL_RO_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ro, Warn, 3, text, length)

#define NN_DETAIL_RO_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ro, Error, 0, text, length)
#define NN_DETAIL_RO_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Error, 1, text, length)
#define NN_DETAIL_RO_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Error, 2, text, length)
#define NN_DETAIL_RO_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Error, 3, text, length)

#define NN_DETAIL_RO_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ro, Fatal, 0, text, length)
#define NN_DETAIL_RO_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Fatal, 1, text, length)
#define NN_DETAIL_RO_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Fatal, 2, text, length)
#define NN_DETAIL_RO_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ro, Fatal, 3, text, length)
