﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Pinmux ドライバライブラリのサスペンド・レジューム機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pinmux {
namespace driver {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief   Pinmux 設定をサスペンドに向けて保存します。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  pinmux の設定値が保存されます。
 *
 * @details
 *  全ピンの Pinmux 設定をサスペンド前に保存します。@n
 *  すでにサスペンド状態で本関数を呼び出した場合、何もしません。
 */
void Suspend() NN_NOEXCEPT;

/**
 * @brief   レジューム後、Pinmux 設定を書き戻します。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。
 *
 * @post
 *  全ピンの Pinmux 設定値がサスペンド前の状態になります。
 *
 * @details
 *  全ピンの Pinmux 設定状態をサスペンド前の状態に戻します。@n
 *  サスペンド前の状態で本関数を呼び出した場合、何もしません。
 */
void Resume() NN_NOEXCEPT;

//! @}

} // dirver
} // pinmux
} // nn
