﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <type_traits>
#include <cstring>

namespace nn { namespace ovln {

struct RawMessage
{
    uint32_t tag;
    uint32_t dataSize;
    std::aligned_storage<120, 8>::type data;
};

enum EnqueuePosition
{
    EnqueuePosition_Front = 0,
    EnqueuePosition_Back = 1,
};

enum OverflowOption
{
    OverflowOption_Error = 0,
    OverflowOption_RemoveFront = 1,
    OverflowOption_RemoveBack = 2,
    OverflowOption_Block = 3,
};

struct SendOption
{
    uint8_t enqueuePosition;
    uint8_t overflowOption;
    Bit16 reserved1;
    Bit32 reserved2;
};

struct SourceName
{
    char name[16];
};

inline bool operator==(const SourceName& lhs, const SourceName& rhs) NN_NOEXCEPT
{
    return std::memcmp(&lhs, &rhs, sizeof(lhs)) == 0;
}

inline bool operator!=(const SourceName& lhs, const SourceName& rhs) NN_NOEXCEPT
{
    return !(lhs == rhs);
}

inline SourceName MakeSourceName(const char* name) NN_NOEXCEPT
{
    SourceName ret = {};
    std::strcpy(ret.name, name);
    return ret;
}

struct QueueAttribute
{
    uint32_t queueLength;
    Bit32 reserved2;
};

}}
