﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ovln/ovln_ServiceTypes.h>
#include <nn/ovln/ovln_CommonTypes.h>
#include <type_traits>

namespace nn { namespace ovln {

Result InitializeSenderLibrary() NN_NOEXCEPT;
void FinalizeSenderLibrary() NN_NOEXCEPT;

class ISender;

class Sender
{
public:

    Sender() NN_NOEXCEPT;
    Result Initialize(const SourceName& sourceName, const QueueAttribute& queueAttribute) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    ~Sender() NN_NOEXCEPT;
    Sender(Sender&& receiver) NN_NOEXCEPT;
    void swap(Sender& other) NN_NOEXCEPT;
    bool IsValid() const NN_NOEXCEPT;
    Sender& operator=(Sender&& rhs) NN_NOEXCEPT;
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return IsValid();
    }

    bool Send(Message message, SendOption option);
    uint32_t GetUnreceivedMessageCount() const NN_NOEXCEPT;

private:

    ISender* m_pSender;

};

}}
