﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ovln { namespace format {

struct AudioVolumeChangeReasonFlag
{
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<0> upButtonPressed;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<1> downButtonPressed;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<2> upAndDownButtonPressed;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<3> headphoneMicJackPlugged;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<4> headphoneMicJackUnplugged;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<5> usbOutputDeviceConnected;
    typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag>::Flag<6> usbOutputDeviceDisconnected;
};

typedef ::nn::util::BitFlagSet<32, AudioVolumeChangeReasonFlag> AudioVolumeChangeReasonFlagSet;

const uint32_t AudioVolumeChangedDataTag = 1000;
const uint32_t AudioHeadphoneVolumeWarningDataTag = 1001;

enum AudioOutputTarget
{
    AudioOutputTarget_HeadphoneMicJack,
    AudioOutputTarget_Speaker,
    AudioOutputTarget_Hdmi,
    AudioOutputTarget_UsbOutputDevice,
};

struct AudioVolumeChangedData
{
    int8_t volume;
    bool mute;
    uint8_t audioOutputTarget;
    AudioVolumeChangeReasonFlagSet reason;
};

}}} // nn::ovln::format
