﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッドに関する公開ヘッダファイル（SDK 開発者向け）
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/os/os_SdkThreadTypes.h>
#include <nn/os/os_ThreadLocalStorageCommon.h>

namespace nn { namespace os {

namespace detail {
    inline uintptr_t* GetSdkInternalTlsArray(ThreadType* thread) NN_NOEXCEPT
    {
        return &(thread->_tlsValueArray[TlsSlotCountMax + 0]);
    }
}

//! @name スレッド関連 API（SDK 開発者専用）
//! @{

//-----------------------------------------------------------------------------
/**
 * @brief   指定された ThreadType オブジェクト内の SdkInternalTlsType 構造体へのポインタを取得します
 *
 * @param[in] thread    ThreadType オブジェクトへのポインタ
 *
 * @return  ThreadType オブジェクト内の SdkInternalTlsType 構造体へのポインタです。
 *
 * @details
 *  nn::os::ThreadType 構造体内に確保された SDK 開発者専用の TLS 領域への
 *  ポインタを取得します。
 *
 *  返値は nn::os::SdkInternalTlsType* というポインタ型であり、
 *  利用者は予め nn::os::SdkInternalTlsType 構造体の中に各ライブラリで使用する
 *  スレッド固有のメンバを定義しておく必要があります。
 *
 */
inline SdkInternalTlsType* SdkGetInternalTlsRegion(ThreadType* thread = nn::os::GetCurrentThread()) NN_NOEXCEPT
{
    return reinterpret_cast<SdkInternalTlsType*>(detail::GetSdkInternalTlsArray(thread));
}

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::os

