﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   割込みイベントに関する共通定義
 */

#pragma once

#include <nn/os/os_Config.h>

//--------------------------------------------------------------------------
//  C++ 向けの宣言
//--------------------------------------------------------------------------

namespace nn { namespace os {

//--------------------------------------------------------------------------
/**
 * @brief   割込みイベントの名前を表す型です。
 */
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
typedef int         InterruptName;
#elif defined(NN_BUILD_CONFIG_OS_WIN32)
typedef const char* InterruptName;
#else
    #error  "未サポートの OS 種別が指定されています。"
#endif


}} // namespace nn::os

