﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

typedef uint32_t nnnetOslMbufIndex;

/* mbuf for inter-process */
typedef struct nnnetOslMbufIndexed
{
    nnnetOslMbufIndex   m_nextIndex;                    /**< Next cluster index */
    nnnetOslMbufIndex   m_prevIndex;                    /**< Previous cluster index */
    void*               m_reserved;
    uint32_t            m_pad;
} nnnetOslMbufIndexedHead;

#ifdef __cplusplus

namespace nn {
namespace net {
namespace osl {

class Mbuf;
class MbufIndexed : public nnnetOslMbufIndexed
{
public:
    friend class MbufPool;
    typedef nnnetOslMbufIndex Index;
    static const uint32_t INVALID_INDEX   = 0xffffffff;

    static MbufIndexed* ConvertToIndexed(Mbuf* pMbuf);
    static Mbuf* ConvertFromIndex(Index index);

    void SetNext(Index index)
    {
        m_nextIndex = index;
    }

    void SetPrevious(Index index)
    {
        m_prevIndex = index;
    }

    Index GetIndex(void) const;

    void Dump(void) const;
};

}
}
}

#endif // __cplusplus

