﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * ndebug.hからインクルードされる、Nintendo SDK 環境用定義
 */

#pragma once

#include <nn/diag.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef NN_BUILD_VERBOSE
/*
    ビルド時にTWL_DEBUG=TRUEを指定するとこちらが有効になります。
*/

#define NDEBUG_ENABLE	/**< 各ファイルで、この定義に囲まれた部分が有効になります。 */
#define NDEBUG_PRINT_ENABLE

#define NDEBUG_Printf	NN_SDK_LOG    /**< DEBUGGERのOutput画面に表示するprintf関数を指定してください。 */
#define NDEBUG_Assert(...)	NN_SDK_ASSERT(__VA_ARGS__)    /**< アサーション関数を指定してください。 */

extern void NDEBUG_Dump(const void *ptr, int32_t len);   /**< 任意のアドレスを16進数でダンプする関数です。 ndebug_main.cに実装されています。*/

#else

#undef NDEBUG_ENABLE
/*
    ビルド時にTWL_DEBUG=TRUEを指定しないとこちらが有効になります。
    NDEBUG_ENABLEで囲まれた部分と、以下の関数が全て無効になります。
*/

#define NDEBUG_Printf(...)
#define NDEBUG_Assert(cond)
#define NDEBUG_Dump(ptr, len)

#endif

#ifdef  __cplusplus
}
#endif
