﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/fs/fs_File.h>
#include <nn/ncm/ncm_PackageInstallTask.h>

namespace nn { namespace ncm {

    class SubmissionPackageInstallTask : public PackageInstallTask
    {
    public:
        SubmissionPackageInstallTask() NN_NOEXCEPT;
        virtual ~SubmissionPackageInstallTask() NN_NOEXCEPT;

        Result Initialize(fs::FileHandle file, ncm::StorageId storage, void* buffer, size_t bufferSize, bool ignoreTicket = false) NN_NOEXCEPT;

    private:
        class Impl;
        std::unique_ptr<Impl> m_Impl;
    };
}}
