﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace ncm {

    struct ProgramLocation
    {
        ProgramId   programId;
        Bit8        storageId;
        Bit8        reserved[7];
    };

    inline ProgramLocation MakeProgramLocation(StorageId storageId, ProgramId programId) NN_NOEXCEPT
    {
        ProgramLocation location = { programId, static_cast<Bit8>(storageId) };
        return location;
    }
}}
