﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_PathString.h>

namespace nn { namespace ncm {

    /**
    * @brief プレイスホルダのファイルパスを作成する関数です。
    *
    * @param[out]   outValue        作成したプレイスホルダのファイルパスです。
    * @param[in]    id              パスを作成するプレイスホルダの ID です。
    * @param[in]    placeHolderPath プレイスホルダを配置するルートディレクトリのパスです。
    *
    */
    typedef void (*MakePlaceHolderPathFunction)(PathString* outValue, PlaceHolderId id, const char* rootPath);

    /**
    * @brief フラットにプレイスホルダを配置するファイルパス作成関数です。
    *
    * @param[out]   outValue        作成したプレイスホルダのファイルパスです。
    * @param[in]    id              パスを作成するプレイスホルダの ID です。
    * @param[in]    placeHolderPath プレイスホルダを配置するルートディレクトリのパスです。
    *
    */
    void MakeFlatPlaceHolderFilePath(PathString* outValue, PlaceHolderId id, const char* rootPath);

    /**
    * @brief SHA256 ハッシュで階層化したディレクトリにプレイスホルダを配置するファイルパス作成関数です。16K クラスタの FAT に最適化されています。
    *
    * @param[out]   outValue        作成したコンテンツのファイルパスです。
    * @param[in]    id              パスを作成するコンテンツの ID です。
    * @param[in]    placeHolderPath コンテンツを配置するルートディレクトリのパスです。
    *
    */
    void MakeSha256HierarchicalPlaceHolderFilePath_ForFat16KCluster(PathString* outValue, PlaceHolderId id, const char* rootPath);

    /**
    * @brief プレースホルダパス作成関数を使ったときに、どの深さまでトラバースするべきかを取得する API です。
    */
    int GetHierarchicalPlaceHolderDirectoryDepth(MakePlaceHolderPathFunction func) NN_NOEXCEPT;

}}
