﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ncm/ncm_ContentId.h>
#include <nn/ncm/ncm_ContentInfo.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentType.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ncm { // NOLINT(whitespace/braces)

class IContentMetaDatabase;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IContentMetaDatabase, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IContentMetaDatabase)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Set, (const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Remove, (const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByType, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListContentInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(List, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type, ::nn::ncm::ApplicationId appId, ::nn::Bit64 min, ::nn::Bit64 max, ::nn::ncm::ContentInstallType installType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestContentMetaKey, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue, ::nn::Bit64 id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplication, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Has, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasAll, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& inArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredSystemVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPatchId, (::nn::sf::Out<::nn::ncm::PatchId> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableForcibly)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LookupOrphanContent, (const ::nn::sf::OutArray<bool>& outList, const ::nn::sf::InArray<::nn::ncm::ContentId>& contentList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasContent, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::ncm::ContentId& contentId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAttributes, (::nn::sf::Out<::nn::Bit8> outAttributes, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredApplicationVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByTypeAndIdOffset, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type, ::std::uint8_t idOffset))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IContentMetaDatabase)

        ::nn::Result Set(const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Set, (key, buffer));
        }

        ::nn::Result Get(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Get, (outValue, key, buffer));
        }

        ::nn::Result Remove(const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Remove, (key));
        }

        ::nn::Result GetContentIdByType(::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetContentIdByType, (outValue, key, type));
        }

        ::nn::Result ListContentInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListContentInfo, (outCount, outArray, key, offset));
        }

        ::nn::Result List(::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type, ::nn::ncm::ApplicationId appId, ::nn::Bit64 min, ::nn::Bit64 max, ::nn::ncm::ContentInstallType installType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(List, (outTotal, outCount, outArray, type, appId, min, max, installType));
        }

        ::nn::Result GetLatestContentMetaKey(::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue, ::nn::Bit64 id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLatestContentMetaKey, (outValue, id));
        }

        ::nn::Result ListApplication(::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplication, (outTotal, outCount, outArray, type));
        }

        ::nn::Result Has(::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Has, (outValue, key));
        }

        ::nn::Result HasAll(::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& inArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasAll, (outValue, inArray));
        }

        ::nn::Result GetSize(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSize, (outValue, key));
        }

        ::nn::Result GetRequiredSystemVersion(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequiredSystemVersion, (outValue, key));
        }

        ::nn::Result GetPatchId(::nn::sf::Out<::nn::ncm::PatchId> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPatchId, (outValue, key));
        }

        ::nn::Result DisableForcibly() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableForcibly);
        }

        ::nn::Result LookupOrphanContent(const ::nn::sf::OutArray<bool>& outList, const ::nn::sf::InArray<::nn::ncm::ContentId>& contentList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LookupOrphanContent, (outList, contentList));
        }

        ::nn::Result Commit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Commit);
        }

        ::nn::Result HasContent(::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::ncm::ContentId& contentId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasContent, (outValue, key, contentId));
        }

        ::nn::Result ListContentMetaInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListContentMetaInfo, (outCount, outArray, key, offset));
        }

        ::nn::Result GetAttributes(::nn::sf::Out<::nn::Bit8> outAttributes, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAttributes, (outAttributes, key));
        }

        ::nn::Result GetRequiredApplicationVersion(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequiredApplicationVersion, (outValue, key));
        }

        ::nn::Result GetContentIdByTypeAndIdOffset(::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type, ::std::uint8_t idOffset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetContentIdByTypeAndIdOffset, (outValue, key, type, idOffset));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IContentMetaDatabase
    {
    public:
        nn::Result Set(const nn::ncm::ContentMetaKey& key, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result Get(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result Remove(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result GetContentIdByType(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type) NN_NOEXCEPT;
        nn::Result ListContentInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT;
        nn::Result List(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outArray, nn::ncm::ContentMetaType type, nn::ncm::ApplicationId appId, nn::Bit64 min, nn::Bit64 max, nn::ncm::ContentInstallType installType) NN_NOEXCEPT;
        nn::Result GetLatestContentMetaKey(nn::sf::Out<nn::ncm::ContentMetaKey> outValue, nn::Bit64 id) NN_NOEXCEPT;
        nn::Result ListApplication(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationContentMetaKey>& outArray, nn::ncm::ContentMetaType type) NN_NOEXCEPT;
        nn::Result Has(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result HasAll(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& inArray) NN_NOEXCEPT;
        nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result GetRequiredSystemVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result GetPatchId(nn::sf::Out<nn::ncm::PatchId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result DisableForcibly() NN_NOEXCEPT;
        nn::Result LookupOrphanContent(const nn::sf::OutArray<bool>& outList, const nn::sf::InArray<nn::ncm::ContentId>& contentList) NN_NOEXCEPT;
        nn::Result Commit() NN_NOEXCEPT;
        nn::Result HasContent(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key, const nn::ncm::ContentId& contentId) NN_NOEXCEPT;
        nn::Result ListContentMetaInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetAttributes(nn::sf::Out<nn::Bit8> outAttributes, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result GetRequiredApplicationVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result GetContentIdByTypeAndIdOffset(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type, std::uint8_t idOffset) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Set(const nn::ncm::ContentMetaKey& key, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result Get(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result Remove(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result GetContentIdByType(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type) NN_NOEXCEPT;
    nn::Result ListContentInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT;
    nn::Result List(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outArray, nn::ncm::ContentMetaType type, nn::ncm::ApplicationId appId, nn::Bit64 min, nn::Bit64 max, nn::ncm::ContentInstallType installType) NN_NOEXCEPT;
    nn::Result GetLatestContentMetaKey(nn::sf::Out<nn::ncm::ContentMetaKey> outValue, nn::Bit64 id) NN_NOEXCEPT;
    nn::Result ListApplication(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationContentMetaKey>& outArray, nn::ncm::ContentMetaType type) NN_NOEXCEPT;
    nn::Result Has(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result HasAll(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& inArray) NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result GetRequiredSystemVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result GetPatchId(nn::sf::Out<nn::ncm::PatchId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result DisableForcibly() NN_NOEXCEPT;
    nn::Result LookupOrphanContent(const nn::sf::OutArray<bool>& outList, const nn::sf::InArray<nn::ncm::ContentId>& contentList) NN_NOEXCEPT;
    nn::Result Commit() NN_NOEXCEPT;
    nn::Result HasContent(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key, const nn::ncm::ContentId& contentId) NN_NOEXCEPT;
    nn::Result ListContentMetaInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetAttributes(nn::sf::Out<nn::Bit8> outAttributes, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result GetRequiredApplicationVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result GetContentIdByTypeAndIdOffset(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type, std::uint8_t idOffset) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ncm::IContentMetaDatabase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Set, (const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Set, (key, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Get, (outValue, key, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Remove, (const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Remove, (key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByType, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetContentIdByType, (outValue, key, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListContentInfo, (outCount, outArray, key, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(List, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type, ::nn::ncm::ApplicationId appId, ::nn::Bit64 min, ::nn::Bit64 max, ::nn::ncm::ContentInstallType installType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(List, (outTotal, outCount, outArray, type, appId, min, max, installType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestContentMetaKey, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue, ::nn::Bit64 id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLatestContentMetaKey, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplication, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplication, (outTotal, outCount, outArray, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Has, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Has, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasAll, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& inArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasAll, (outValue, inArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSize, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredSystemVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequiredSystemVersion, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPatchId, (::nn::sf::Out<::nn::ncm::PatchId> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPatchId, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableForcibly)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableForcibly);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LookupOrphanContent, (const ::nn::sf::OutArray<bool>& outList, const ::nn::sf::InArray<::nn::ncm::ContentId>& contentList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LookupOrphanContent, (outList, contentList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Commit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasContent, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::ncm::ContentId& contentId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasContent, (outValue, key, contentId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListContentMetaInfo, (outCount, outArray, key, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAttributes, (::nn::sf::Out<::nn::Bit8> outAttributes, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAttributes, (outAttributes, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredApplicationVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequiredApplicationVersion, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByTypeAndIdOffset, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type, ::std::uint8_t idOffset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetContentIdByTypeAndIdOffset, (outValue, key, type, idOffset));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ncm::IContentMetaDatabase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ncm::IContentMetaDatabase))

    // nn::Result Set(const nn::ncm::ContentMetaKey& key, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Set)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Set)

    // nn::Result Get(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Get)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Get)

    // nn::Result Remove(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Remove)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Remove)

    // nn::Result GetContentIdByType(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetContentIdByType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ContentId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetContentIdByType)

    // nn::Result ListContentInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListContentInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListContentInfo)

    // nn::Result List(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outArray, nn::ncm::ContentMetaType type, nn::ncm::ApplicationId appId, nn::Bit64 min, nn::Bit64 max, nn::ncm::ContentInstallType installType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(List)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentMetaType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(installType, (::nn::ncm::ContentInstallType), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(min, (::nn::Bit64), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(max, (::nn::Bit64), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (type, installType, appId, min, max))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTotal, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outTotal, outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTotal), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(min), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(max), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(installType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(List)

    // nn::Result GetLatestContentMetaKey(nn::sf::Out<nn::ncm::ContentMetaKey> outValue, nn::Bit64 id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLatestContentMetaKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLatestContentMetaKey)

    // nn::Result ListApplication(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationContentMetaKey>& outArray, nn::ncm::ContentMetaType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::nn::ncm::ApplicationContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentMetaType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTotal, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outTotal, outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTotal), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplication)

    // nn::Result Has(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Has)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Has)

    // nn::Result HasAll(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& inArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasAll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inArray, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasAll)

    // nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSize)

    // nn::Result GetRequiredSystemVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequiredSystemVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequiredSystemVersion)

    // nn::Result GetPatchId(nn::sf::Out<nn::ncm::PatchId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPatchId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::PatchId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPatchId)

    // nn::Result DisableForcibly() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableForcibly)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableForcibly)

    // nn::Result LookupOrphanContent(const nn::sf::OutArray<bool>& outList, const nn::sf::InArray<nn::ncm::ContentId>& contentList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LookupOrphanContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<bool>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(contentList, 1, (const ::nn::sf::InArray<::nn::ncm::ContentId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, contentList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LookupOrphanContent)

    // nn::Result Commit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Commit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Commit)

    // nn::Result HasContent(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key, const nn::ncm::ContentId& contentId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentId, (::nn::ncm::ContentId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (contentId, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasContent)

    // nn::Result ListContentMetaInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListContentMetaInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentMetaInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListContentMetaInfo)

    // nn::Result GetAttributes(nn::sf::Out<nn::Bit8> outAttributes, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAttributes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAttributes, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outAttributes))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAttributes), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAttributes)

    // nn::Result GetRequiredApplicationVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequiredApplicationVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequiredApplicationVersion)

    // nn::Result GetContentIdByTypeAndIdOffset(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type, std::uint8_t idOffset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetContentIdByTypeAndIdOffset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(idOffset, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (type, idOffset, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ContentId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(idOffset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetContentIdByTypeAndIdOffset)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaKey), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentId), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentInfo), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentInstallType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationContentMetaKey), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::PatchId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaInfo), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ncm::IContentMetaDatabase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ncm::IContentMetaDatabase))

    // nn::Result Set(const nn::ncm::ContentMetaKey& key, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Set, (const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Set)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Set)
    }

    // nn::Result Get(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Get, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Get)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Get)
    }

    // nn::Result Remove(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Remove, (const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Remove)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Remove)
    }

    // nn::Result GetContentIdByType(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByType, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetContentIdByType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetContentIdByType)
    }

    // nn::Result ListContentInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListContentInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListContentInfo)
    }

    // nn::Result List(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outArray, nn::ncm::ContentMetaType type, nn::ncm::ApplicationId appId, nn::Bit64 min, nn::Bit64 max, nn::ncm::ContentInstallType installType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(List, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type, ::nn::ncm::ApplicationId appId, ::nn::Bit64 min, ::nn::Bit64 max, ::nn::ncm::ContentInstallType installType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(List)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTotal)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(min)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(max)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(installType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(List)
    }

    // nn::Result GetLatestContentMetaKey(nn::sf::Out<nn::ncm::ContentMetaKey> outValue, nn::Bit64 id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestContentMetaKey, (::nn::sf::Out<::nn::ncm::ContentMetaKey> outValue, ::nn::Bit64 id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLatestContentMetaKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLatestContentMetaKey)
    }

    // nn::Result ListApplication(nn::sf::Out<std::int32_t> outTotal, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationContentMetaKey>& outArray, nn::ncm::ContentMetaType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplication, (::nn::sf::Out<::std::int32_t> outTotal, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationContentMetaKey>& outArray, ::nn::ncm::ContentMetaType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTotal)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplication)
    }

    // nn::Result Has(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Has, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Has)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Has)
    }

    // nn::Result HasAll(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& inArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasAll, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& inArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasAll)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasAll)
    }

    // nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSize)
    }

    // nn::Result GetRequiredSystemVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredSystemVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequiredSystemVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequiredSystemVersion)
    }

    // nn::Result GetPatchId(nn::sf::Out<nn::ncm::PatchId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPatchId, (::nn::sf::Out<::nn::ncm::PatchId> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPatchId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPatchId)
    }

    // nn::Result DisableForcibly() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableForcibly)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableForcibly)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableForcibly)
    }

    // nn::Result LookupOrphanContent(const nn::sf::OutArray<bool>& outList, const nn::sf::InArray<nn::ncm::ContentId>& contentList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LookupOrphanContent, (const ::nn::sf::OutArray<bool>& outList, const ::nn::sf::InArray<::nn::ncm::ContentId>& contentList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LookupOrphanContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LookupOrphanContent)
    }

    // nn::Result Commit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Commit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Commit)
    }

    // nn::Result HasContent(nn::sf::Out<bool> outValue, const nn::ncm::ContentMetaKey& key, const nn::ncm::ContentId& contentId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasContent, (::nn::sf::Out<bool> outValue, const ::nn::ncm::ContentMetaKey& key, const ::nn::ncm::ContentId& contentId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasContent)
    }

    // nn::Result ListContentMetaInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaInfo>& outArray, const nn::ncm::ContentMetaKey& key, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaInfo>& outArray, const ::nn::ncm::ContentMetaKey& key, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListContentMetaInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListContentMetaInfo)
    }

    // nn::Result GetAttributes(nn::sf::Out<nn::Bit8> outAttributes, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAttributes, (::nn::sf::Out<::nn::Bit8> outAttributes, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAttributes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAttributes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAttributes)
    }

    // nn::Result GetRequiredApplicationVersion(nn::sf::Out<std::uint32_t> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredApplicationVersion, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequiredApplicationVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequiredApplicationVersion)
    }

    // nn::Result GetContentIdByTypeAndIdOffset(nn::sf::Out<nn::ncm::ContentId> outValue, const nn::ncm::ContentMetaKey& key, nn::ncm::ContentType type, std::uint8_t idOffset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentIdByTypeAndIdOffset, (::nn::sf::Out<::nn::ncm::ContentId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::ContentType type, ::std::uint8_t idOffset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetContentIdByTypeAndIdOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(idOffset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetContentIdByTypeAndIdOffset)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ncm::IContentMetaDatabase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ncm::IContentMetaDatabase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Set)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Set)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Get)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Remove)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Remove)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetContentIdByType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetContentIdByType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListContentInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListContentInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(List)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(List)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTotal),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(min),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(max),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(installType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLatestContentMetaKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLatestContentMetaKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTotal),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Has)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Has)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasAll)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequiredSystemVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequiredSystemVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPatchId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPatchId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableForcibly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableForcibly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LookupOrphanContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(contentList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LookupOrphanContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(contentList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListContentMetaInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListContentMetaInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAttributes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAttributes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAttributes),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequiredApplicationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequiredApplicationVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetContentIdByTypeAndIdOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetContentIdByTypeAndIdOffset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(idOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Set)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Get)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Remove)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetContentIdByType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListContentInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(List)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLatestContentMetaKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Has)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequiredSystemVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPatchId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableForcibly)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LookupOrphanContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListContentMetaInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAttributes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequiredApplicationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetContentIdByTypeAndIdOffset)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ncm::IContentMetaDatabase))
