﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_AutoBuffer.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>

namespace nn { namespace ncm {

    Result ReadContentMetaPath(AutoBuffer* outValue, const char* path) NN_NOEXCEPT;
    Result GetContentMetaPath(Path* outPath, const StorageContentMetaKey storageKey) NN_NOEXCEPT;

    Result VerifyPatchHistory(bool* outFound, ContentMetaDatabase* db, const ContentMetaKey& key, const PackagedContentMetaReader& reader) NN_NOEXCEPT;
}}
