﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaType.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace ncm {

    enum class ContentInstallType : Bit8
    {
        Full     = 0,
        FragmentOnly = 1,
        Unknown  = 7,
    };
    struct ContentMetaKey
    {
        Bit64              id;
        uint32_t           version;
        ContentMetaType    type;
        ContentInstallType installType; // 実質下位 3bit を使っている
        Bit8               reserved[2];

        bool operator < (const ContentMetaKey& rhs) const NN_NOEXCEPT;

        bool operator == (const ContentMetaKey& rhs) const NN_NOEXCEPT;

        bool operator != (const ContentMetaKey& rhs) const NN_NOEXCEPT;

        static ContentMetaKey Make(SystemProgramId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(SystemDataId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(ApplicationId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(PatchId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(PatchId id, uint32_t version, ContentInstallType installType) NN_NOEXCEPT;

        static ContentMetaKey Make(DeltaId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(SystemUpdateId id, uint32_t version) NN_NOEXCEPT;

        static ContentMetaKey Make(Bit64 id, uint32_t version, ContentMetaType type) NN_NOEXCEPT;

        static ContentMetaKey Make(Bit64 id, uint32_t version, ContentMetaType type, ContentInstallType installType) NN_NOEXCEPT;

        static ContentMetaKey MakeUnknownType(Bit64 id, uint32_t version) NN_NOEXCEPT;
    };

    struct ApplicationContentMetaKey
    {
        ContentMetaKey      key;
        ncm::ApplicationId  applicationId;
    };

    struct StorageContentMetaKey
    {
        ContentMetaKey      key;
        StorageId           storageId;
        Bit8                reserved[7];

        bool operator == (const StorageContentMetaKey& rhs) const NN_NOEXCEPT
        {
            return key == rhs.key && storageId == rhs.storageId;
        }
        bool operator < (const StorageContentMetaKey& rhs) const NN_NOEXCEPT
        {
            return (key == rhs.key) ? (storageId < rhs.storageId) : (key < rhs.key);
        }
    };
}}
