﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_IContentMetaDatabase.h>
#include <nn/kvdb/kvdb_FlatMapKeyValueStore.h>
#include <nn/fs/fs_Mount.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace ncm {

    typedef kvdb::FlatMapKeyValueStore<ContentMetaKey> ContentMetaKeyValueStore;

    class ContentMetaDatabaseImpl
    {
        NN_DISALLOW_COPY(ContentMetaDatabaseImpl);
        NN_DISALLOW_MOVE(ContentMetaDatabaseImpl);

    public:
        explicit ContentMetaDatabaseImpl(ContentMetaKeyValueStore* kvs, const char* mountName) NN_NOEXCEPT;

        Result Set(const ContentMetaKey& key, const sf::InBuffer& buffer) NN_NOEXCEPT;

        Result Get(sf::Out<::std::uint64_t> outValue, const ContentMetaKey& key, const sf::OutBuffer& buffer) const NN_NOEXCEPT;

        Result Remove(const ContentMetaKey& key) NN_NOEXCEPT;

        Result GetContentIdByType(sf::Out<ContentId> outValue, const ContentMetaKey& key, ContentType type) const NN_NOEXCEPT;

        Result GetContentIdByTypeAndIdOffset(sf::Out<ContentId> outValue, const ContentMetaKey& key, ContentType type, uint8_t idOffset) const NN_NOEXCEPT;

        Result ListContentInfo(sf::Out<std::int32_t> outCount, const sf::OutArray<ContentInfo>& outArray, const ContentMetaKey& key, int offset) const NN_NOEXCEPT;

        Result ListContentMetaInfo(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::ContentMetaInfo>& outArray, const ncm::ContentMetaKey& key, std::int32_t offset) const NN_NOEXCEPT;

        Result List(sf::Out<std::int32_t> outTotal, sf::Out<std::int32_t> outCount, const sf::OutArray<ContentMetaKey>& outArray, ContentMetaType type, ApplicationId appId, Bit64 min, Bit64 max, ContentInstallType installType) const NN_NOEXCEPT;

        Result GetLatestContentMetaKey(sf::Out<ContentMetaKey> outValue, Bit64 id) const NN_NOEXCEPT;

        Result ListApplication(sf::Out<std::int32_t> outTotal, sf::Out<std::int32_t> outCount, const sf::OutArray<ApplicationContentMetaKey>& outArray, ContentMetaType type) const NN_NOEXCEPT;

        Result Has(sf::Out<bool> outValue, const ncm::ContentMetaKey& key) const NN_NOEXCEPT;

        Result HasAll(sf::Out<bool> outValue, const sf::InArray<ncm::ContentMetaKey>& inArray) const NN_NOEXCEPT;

        Result HasContent(sf::Out<bool> outValue, const ncm::ContentMetaKey& key, const ncm::ContentId& contentId) const NN_NOEXCEPT;

        Result GetSize(sf::Out<std::uint64_t> outValue, const ncm::ContentMetaKey& key) const NN_NOEXCEPT;

        Result GetRequiredSystemVersion(sf::Out<std::uint32_t> outValue, const ncm::ContentMetaKey& key) const NN_NOEXCEPT;

        Result GetPatchId(sf::Out<ncm::PatchId> outValue, const ncm::ContentMetaKey& key) const NN_NOEXCEPT;

        Result GetAttributes(sf::Out<Bit8> outAttributes, const ncm::ContentMetaKey& key) const NN_NOEXCEPT;

        Result LookupOrphanContent(const sf::OutArray<bool>& outList, const sf::InArray<ncm::ContentId>& contentList) const NN_NOEXCEPT;

        Result Commit() NN_NOEXCEPT;

        Result DisableForcibly() NN_NOEXCEPT;

        Result GetRequiredApplicationVersion(sf::Out<std::uint32_t> outValue, const ContentMetaKey& key) const NN_NOEXCEPT;

    private:
        Result FindLatestKeyById(ContentMetaKey* outValue, Bit64 id) const NN_NOEXCEPT;
        Result GetContentIdImpl(sf::Out<ContentId> outValue, const ContentMetaKey& key, ContentType type, util::optional<uint8_t> idOffset) const NN_NOEXCEPT;

        ContentMetaKeyValueStore* m_Kvs;
        char m_MountName[fs::MountNameLengthMax + 1];
        bool m_IsDisabled;
    };
}}
